/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.link.collector.records;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordLinkCollectorAddRoutingHint
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"3a383323-aa98-4fde-99c8-a8ba2c1e0a4f");
    public static final String NAME = "LinkCollectorAddRoutingHint";
    public static final String DESCRIPTION = "Add a routing hint to find other segments";
    public static final String SLOT_ROUTING_NODE = "2";
    public static final String SLOT_SEGMENT = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CNodeId getRoutingNode(@NotNull CRecord aRecord, CNodeId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ROUTING_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeId)slot.getValue();
    }

    public static CSegmentId getSegment(@NotNull CRecord aRecord, CSegmentId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SEGMENT);
        if (slot == null) {
            return aDefault;
        }
        return (CSegmentId)slot.getValue();
    }

    public static void setRoutingNode(@NotNull CRecord aRecord, CNodeId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ID, (Object)aValue);
        aRecord.addSlot(SLOT_ROUTING_NODE, slot);
    }

    public static void setSegment(@NotNull CRecord aRecord, CSegmentId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.SEGMENT_ID, (Object)aValue);
        aRecord.addSlot(SLOT_SEGMENT, slot);
    }
}

