/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.icon.store;

import de.sillysky.nyssr.impl.remoteskin.client.icon.store.CIconEntry;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CIconList {
    private final Map<String, CIconEntry> mIcons = new ConcurrentHashMap<String, CIconEntry>();

    CIconList() {
    }

    boolean addIcon(@NotNull CIconEntry aIcon) {
        String name = aIcon.getName();
        CIconEntry entry = this.mIcons.get(name);
        if (entry == null) {
            this.mIcons.put(name, aIcon);
            return true;
        }
        String md5New = aIcon.getMd5();
        if (CUtilString.isValid((String)md5New) && !md5New.equals(entry.getMd5())) {
            this.mIcons.put(name, aIcon);
            return true;
        }
        return false;
    }

    @Nullable
    CIconEntry removeIcon(@NotNull String aName) {
        return this.mIcons.remove(aName);
    }

    @Nullable
    CIconEntry get(@Nullable String aName) {
        if (CUtilString.isValid((String)aName)) {
            return this.mIcons.get(aName);
        }
        return null;
    }

    boolean hasIcon(@Nullable String aName) {
        CIconEntry e = this.mIcons.get(aName);
        if (e != null) {
            return e.getIcon() != null;
        }
        return false;
    }
}

