/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.db;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.db.ETransportDirection;
import de.sillysky.nyssr.record.db.ISlotRecord;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class CSlotEntry
implements ISlotRecord {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSlotEntry.class);
    @NotNull
    private final ISlotFactory mSlotFactory;
    @NotNull
    private final String mKey;
    @NotNull
    private final String mName;
    @NotNull
    private final String mDataType;
    private final boolean mMandatory;
    @NotNull
    private final ETransportDirection mTransportDirection;
    private String mSortingHelp;
    @NotNull
    private String mDescription = "";
    private CSlotType mSlotType;

    public CSlotEntry(@NotNull ISlotFactory aSlotFactory, @NotNull String aKey, @NotNull String aDataType, @NotNull String aName, @NotNull ETransportDirection aTransportDirection, boolean aIsMandatory) {
        this.mSlotFactory = aSlotFactory;
        this.mKey = aKey;
        this.mDataType = aDataType;
        this.mSlotType = this.mSlotFactory.getSlotTypeByName(aDataType);
        this.mName = aName;
        this.mSortingHelp = aName;
        this.mMandatory = aIsMandatory;
        this.mTransportDirection = aTransportDirection;
    }

    @Override
    public int compareTo(ISlotRecord aOther) {
        return this.mSortingHelp.compareTo(aOther.getSortingHelp());
    }

    public String getCamelCase() {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < this.mName.length(); ++i) {
            char c = this.mName.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (c == '_') {
                c = this.mName.charAt(++i);
                c = Character.toUpperCase(c);
            } else {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public Collection<String> getCommonDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Slot " + this.mName);
        list.add("data type = " + this.mDataType);
        list.add("mandatory = " + this.mMandatory);
        list.add("direction = " + String.valueOf((Object)this.mTransportDirection));
        return list;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.mKey;
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public CSlotType getSlotType() {
        if (this.mSlotType == null) {
            this.mSlotType = this.mSlotFactory.getSlotTypeByName(this.mDataType);
            if (this.mSlotType == null) {
                LOG.warn("CSlotRecord: SlotType is unknown: {}", new Object[]{this.mDataType});
            }
        }
        return this.mSlotType;
    }

    @Override
    @NotNull
    public String getSlotTypeName() {
        return this.mDataType;
    }

    @Override
    public String getSortingHelp() {
        return this.mSortingHelp;
    }

    public void setSortingHelp(String aSortingHelp) {
        this.mSortingHelp = aSortingHelp;
    }

    @Override
    @NotNull
    public ETransportDirection getTransportDirection() {
        return this.mTransportDirection;
    }

    @Override
    public boolean isMandatory() {
        return this.mMandatory;
    }

    public String toString() {
        return "Slot " + this.mDataType + " " + this.mName;
    }

    public String toString(ISlot aSlot) {
        return "Slot(" + this.mDataType + "." + this.mName + "=" + aSlot.valueToString();
    }
}

