/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.connection.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.gatekeeper.IGateKeeper;
import de.sillysky.nyssr.gatekeeper.records.CRecordGateKeeperAdd;
import de.sillysky.nyssr.gatekeeper.records.CRecordGateKeeperRemove;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionEntry;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionEntryList;
import de.sillysky.nyssr.impl.network.connection.registry.CConstants;
import de.sillysky.nyssr.impl.network.connection.registry.CTransportPrimer;
import de.sillysky.nyssr.impl.network.connection.registry.IDependencies;
import de.sillysky.nyssr.impl.network.connection.registry.records.CRecordConnectionValidated;
import de.sillysky.nyssr.impl.network.connection.registry.records.CRecordNotifyConnectionClosed;
import de.sillysky.nyssr.impl.network.connection.registry.records.CRecordTimer;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.impl.network.transport.ITransport;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.transport.records.CRecordRouteMessage;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorForwardToNextNode;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.IConnectionRegistry;
import de.sillysky.nyssr.network.INetworkReady;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.network.connection.dto.CConnectionUtil;
import de.sillysky.nyssr.network.connection.records.CRecordDataConnection;
import de.sillysky.nyssr.network.records.CRecordNetworkGetConnection;
import de.sillysky.nyssr.network.records.CRecordNetworkGetConnectionList;
import de.sillysky.nyssr.network.records.CRecordNetworkIncomingMessage;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionClosed;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionDeregistered;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionOpened;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionRegistered;
import de.sillysky.nyssr.network.records.CRecordNetworkRoutePacket;
import de.sillysky.nyssr.network.records.CRecordNetworkSendToRemote;
import de.sillysky.nyssr.network.transport.records.CRecordServiceNotifyTransportClosed;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CConnectionRegistry
extends CTarget
implements IConnectionRegistry,
IService {
    private static final String LIST_CONNECTIONS = "list connections";
    private static final String HELP_LIST_CONNECTIONS = "List TCP connections";
    private static final ILogger LOG = CLoggerFactory.getLogger(CConnectionRegistry.class);
    private static final ILogger LOG_LOST = CLoggerFactory.getLogger((String)"network.lost");
    private static final ILogger LOG_TO_REMOTE = CLoggerFactory.getLogger((String)"network.send.to.remote");
    private final IDependencies mDependencies;
    private final AtomicReference<IGateKeeper> mGateKeeper = new AtomicReference<Object>(null);
    private final CConnectionEntryList mConnectionList = new CConnectionEntryList();
    private long mRemoveTimeout;

    public CConnectionRegistry(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkNotifyConnectionOpened.ID, this::asyncNotifyConnectionOpened);
        this.addMessageHandler(CRecordNetworkNotifyConnectionClosed.ID, this::asyncNetworkNotifyConnectionClosed);
        this.addMessageHandler(CRecordNetworkGetConnection.ID, this::asyncGetConnection);
        this.addMessageHandler(CRecordNetworkGetConnectionList.ID, this::asyncGetConnectionList);
        this.addMessageHandler(CRecordConnectionValidated.ID, this::asyncConnectionValidated);
        this.addMessageHandler(CRecordServiceNotifyTransportClosed.ID, this::asyncNotifyTransportClosed);
        this.addMessageHandler(CRecordRouteMessage.ID, this::asyncRouteMessage);
        this.addMessageHandler(CRecordNetworkIncomingMessage.ID, this::asyncIncomingMessage);
        this.addMessageHandler(CRecordNetworkRoutePacket.ID, this::asyncRoutePacket);
        this.addMessageHandler(CRecordGateKeeperAdd.ID, this::asyncAddGateKeeper);
        this.addMessageHandler(CRecordGateKeeperRemove.ID, this::asyncRemoveGateKeeper);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
        this.addMessageHandler(CRecordNotifyConnectionClosed.ID, this::asyncNotifyConnectionClosed);
        this.addMessageHandler(CRecordTimer.ID, this::asyncTimer);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        aServiceRegistry.registerService(IConnectionRegistry.class, (Object)this);
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
        String s = preferences.get("remove.connection.timeout.in.seconds", null);
        this.mRemoveTimeout = CUtilLong.fromString((String)s, (long)0L);
        LOG.debug("RemoveTimeout is {} seconds", new Object[]{this.mRemoveTimeout});
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CConstants.NID, "TRANSPORT");
        ns.getTargetRegistry().registerTarget((ITarget)this, CConstants.TID);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
        aServiceRegistry.deregisterService((Object)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(address, "ConnectionRegistry");
        CRecordHelper.addObserver(CRecordRouteMessage.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordNetworkRoutePacket.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordNetworkNotifyConnectionOpened.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordNetworkNotifyConnectionClosed.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordNetworkGetConnection.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordNetworkGetConnectionList.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordServiceNotifyTransportClosed.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordNetworkIncomingMessage.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordGateKeeperAdd.class, (ITarget)this, (boolean)true);
        this.sendAddCli();
        CServiceRegistry.getInstance().registerService(INetworkReady.class, (Object)this);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetConnection(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID id = CRecordNetworkGetConnection.getConnectionId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"ID is null", (Object[])new Object[0]);
        CConnectionDto entry = this.getConnection(id);
        if (entry == null) {
            aEnvelope.setResult(5, "Connection " + String.valueOf(id) + " not found.");
        } else {
            CRecord record = CConnectionUtil.toRecord(entry);
            CRecordNetworkGetConnection.setConnection((CRecord)aRecord, (CRecord)record);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetConnectionList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Collection<UUID> list = this.getConnectionList();
        ArrayList<CRecord> recordList = new ArrayList<CRecord>();
        for (UUID id : list) {
            CConnectionDto connection = this.getConnection(id);
            if (connection == null) continue;
            CRecord rec = CConnectionUtil.toRecord(connection);
            recordList.add(rec);
        }
        if (!recordList.isEmpty()) {
            CRecord[] arr = recordList.toArray(new CRecord[0]);
            CRecordNetworkGetConnectionList.setConnections((CRecord)aRecord, (CRecord[])arr);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncIncomingMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CMessage msg = CRecordNetworkIncomingMessage.getMessage((CRecord)aRecord, null);
        if (msg == null) {
            aEnvelope.setResult(7, "Message is null.");
        } else {
            UUID id = CRecordNetworkIncomingMessage.getConnectionId((CRecord)aRecord, null);
            if (id == null) {
                aEnvelope.setResult(7, "Connection ID is null.");
            } else {
                CConnectionDto connection = this.getConnection(id);
                if (connection == null) {
                    aEnvelope.setResult(7, "Connection ID is unknown.");
                } else {
                    this.sendToLocal(connection, msg);
                    aEnvelope.setResultSuccess();
                }
            }
        }
        return true;
    }

    private boolean asyncNetworkNotifyConnectionClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord connection = CRecordNetworkNotifyConnectionClosed.getConnection((CRecord)aRecord, null);
        UUID id = CRecordDataConnection.getConnectionId((CRecord)connection, null);
        this.notifyConnectionClosed(id);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyConnectionClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID connectionId = CRecordNotifyConnectionClosed.getConnectionId(aRecord, null);
        this.notifyConnectionClosed(connectionId);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyConnectionOpened(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord record = CRecordNetworkNotifyConnectionOpened.getConnection((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Missing Connection Record", (Object[])new Object[0]);
        CConnectionDto connection = CConnectionUtil.fromRecord(record);
        CUtilCheck.checkNotNull((Object)connection, (String)"Invalid Connection Record", (Object[])new Object[0]);
        CTransportPrimer primer = new CTransportPrimer(this.mDependencies, this.getAddress(), connection);
        this.getTargetRegistry().registerTarget((ITarget)primer);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyTransportClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID connectionID = CRecordServiceNotifyTransportClosed.getConnectionId((CRecord)aRecord, null);
        try {
            this.notifyConnectionClosed(connectionID);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Exception during CRecordNotifyTransportClosed: {}", new Object[]{e.getMessage()});
            aEnvelope.setResult(e.getError());
        }
        return true;
    }

    private boolean asyncAddGateKeeper(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Object gateKeeper = CRecordGateKeeperAdd.getGateKeeper((CRecord)aRecord, null);
        if (gateKeeper instanceof IGateKeeper) {
            this.mGateKeeper.compareAndSet(null, (IGateKeeper)gateKeeper);
            aEnvelope.setResultSuccess();
        } else {
            LOG.error("Object is not a Gatekeeper");
        }
        return true;
    }

    private boolean asyncRemoveGateKeeper(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Object gateKeeper = CRecordGateKeeperRemove.getGateKeeper((CRecord)aRecord, null);
        if (gateKeeper instanceof IGateKeeper) {
            this.mGateKeeper.compareAndSet((IGateKeeper)gateKeeper, null);
            aEnvelope.setResultSuccess();
        } else {
            LOG.error("Object is not a Gatekeeper");
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncConnectionValidated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord record = CRecordConnectionValidated.getConnection(aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Invalid Connection", (Object[])new Object[0]);
        CConnectionDto connection = CConnectionUtil.fromRecord(record);
        CUtilCheck.checkNotNull((Object)connection, (String)"Invalid Connection", (Object[])new Object[0]);
        CUtilCheck.checkNotNull((Object)connection.getRemoteNodeAddress(), (String)"Invalid Remote Node Address", (Object[])new Object[0]);
        CUtilCheck.checkNotNull((Object)connection.getRemoteInstanceID(), (String)"Invalid Remote Instance ID", (Object[])new Object[0]);
        CConnectionEntry entry = this.mConnectionList.findConnection(connection.getRemoteNodeAddress(), connection.getRemoteInstanceID());
        if (entry != null) {
            entry.resume(connection);
        } else {
            entry = new CConnectionEntry(connection);
            this.mConnectionList.add(entry);
            ITransport transport = this.mDependencies.getTransportFactory().createTransport(this.getAddress(), connection);
            entry.setTransport(transport);
            LOG.debug("Connection {} added.", new Object[]{connection.getID()});
            this.sendNotifyConnectionRegistered(connection);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRouteMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        block4: {
            if (aEnvelope.isAnswer()) {
                return false;
            }
            CMessage message = CRecordRouteMessage.getMessage((CRecord)aRecord, null);
            if (message == null) {
                LOG.error("Message is null.");
                aEnvelope.setResult(7, "Message is null.");
                return true;
            }
            try {
                this.routeMessage(message);
                aEnvelope.setResultSuccess();
            }
            catch (CException e) {
                CNodeAddress backNode;
                String text = e.getCombinedText();
                LOG.error("Exception during RouteMessage: {}", new Object[]{text});
                CEnvelope envelope = message.getEnvelope();
                if (envelope.isAnswer() || !this.isReachable(backNode = envelope.getSender().getNodeAddress())) break block4;
                LOG.error("Send Message back: {}", new Object[]{message});
                envelope.setResult(e.getError());
                envelope.setBlocked(false);
                this.getMessageSender().sendBack(message);
            }
        }
        return true;
    }

    private boolean asyncRoutePacket(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress destinationNode = CRecordNetworkRoutePacket.getDestinationNode((CRecord)aRecord, null);
        if (destinationNode == null) {
            aEnvelope.setResult(2503, "Invalid Node.");
            return true;
        }
        CNodeAddress nextNode = this.mDependencies.getRouter().getNextNode(destinationNode, true);
        if (nextNode == null) {
            aEnvelope.setResult(5305, "Unreachable Node.");
            return true;
        }
        CTargetAddress tr = this.getTransportAddress(nextNode);
        if (tr == null) {
            aEnvelope.setResult(5302, "Unknown node ID.");
            return true;
        }
        CPacketMessage packet = (CPacketMessage)CRecordNetworkRoutePacket.getPacket((CRecord)aRecord, null);
        LOG_TO_REMOTE.debug("Route Message to {}, size = {}", new Object[]{packet.getDestination(), packet.size()});
        aEnvelope.forwardMessage(tr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (LIST_CONNECTIONS.equalsIgnoreCase(command)) {
            String s = this.mConnectionList.printConnectionTable();
            CRecordCliHandle.setOutput((CRecord)aRecord, (String)s);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID connectionId = CRecordTimer.getConnectionId(aRecord, null);
        if (connectionId != null) {
            this.notifyReconnectTimeout(connectionId);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void notifyConnectionClosed(@Nullable UUID aID) throws CException {
        if (aID == null) {
            throw new CException(7).append("ID is null");
        }
        CConnectionEntry connection = this.mConnectionList.get(aID);
        if (connection == null) {
            LOG.error("Deregister Connection: {} not Found", new Object[]{aID});
            return;
        }
        if (this.mRemoveTimeout > 0L) {
            if (!connection.isStopped()) {
                LOG_LOST.debug("Connection closed: ID = {}. Start timer for connection recovery, timeout = {} seconds", new Object[]{aID, this.mRemoveTimeout});
                connection.stop();
                CRecord record = CRecordTimer.create();
                CRecordTimer.setConnectionId(record, aID);
                long handle = this.mDependencies.getTimerManager().createAndStartTimer(CRecordTimer.ID, this.getAddress(), this.mRemoveTimeout * 1000L, false, record);
                connection.setTimerHandle(handle);
            }
        } else {
            this.notifyReconnectTimeout(aID);
        }
    }

    private void notifyReconnectTimeout(@Nullable UUID aID) throws CException {
        CConnectionEntry connection;
        if (aID != null && (connection = this.mConnectionList.get(aID)) != null) {
            ITransport transport;
            LOG_LOST.debug("Connection recovery timeout. Remove Connection {}.", new Object[]{aID});
            this.mConnectionList.remove(aID);
            CNodeAddress remoteNodeAddress = connection.getConnection().getRemoteNodeAddress();
            Collection<CConnectionEntry> entries = this.mConnectionList.getEntriesForNode(remoteNodeAddress);
            if (entries.isEmpty()) {
                this.mDependencies.getRouter().removeDirectLink(CNodeAddress.getLocal(), remoteNodeAddress);
            }
            if ((transport = connection.getTransport()) != null) {
                this.mDependencies.getTransportFactory().deleteTransport(transport);
                connection.setTransport(null);
            }
            LOG.debug("Connection {} removed.", new Object[]{aID});
            this.sendNotifyConnectionRemoved(connection.getConnection());
        }
    }

    @Nullable
    private CConnectionDto getConnection(@NotNull UUID aConnectionID) {
        CConnectionEntry entry = this.mConnectionList.get(aConnectionID);
        return entry == null ? null : entry.getConnection();
    }

    private Collection<UUID> getConnectionList() {
        return this.mConnectionList.getConnectionList();
    }

    public Collection<CNodeAddress> getNeighborNodes() {
        return this.mConnectionList.getNeighborNodes();
    }

    private CTargetAddress getTransportAddress(@Nullable CNodeAddress aDestination) {
        CTargetAddress result = null;
        if (aDestination != null) {
            ITransport tr;
            CConnectionEntry e = this.mConnectionList.getEntryForNode(aDestination);
            if (e != null && (tr = e.getTransport()) != null) {
                result = tr.getAddress();
            }
            if (result == null) {
                LOG.warn("Routing: No transport found for node ID: {}", new Object[]{aDestination});
            }
        }
        return result;
    }

    private boolean isReachable(@NotNull CNodeAddress aNode) {
        return this.mDependencies.getRouter().isReachable(aNode);
    }

    private void routeMessage(@NotNull CMessage aMsg) throws CException {
        CConnectionEntry entry;
        CRecord record = aMsg.getRecord();
        CEnvelope envelope = aMsg.getEnvelope();
        CTargetAddress receiver = envelope.getReceiver();
        LOG_TO_REMOTE.debug("Route Message {} to {}", new Object[]{record.getId(), receiver});
        envelope.ensureCompleteAddresses();
        CNodeAddress node = receiver.getNodeAddress();
        if (CNodeAddress.getLocal().equals((Object)node)) {
            throw new CException(7).append("Node is local, not remote.");
        }
        CNodeAddress nextNode = this.mDependencies.getRouter().getNextNode(node, false);
        if (nextNode == null) {
            CNodeId nodeId = this.mDependencies.getRoutingHintRegistry().getBridgeNode(node);
            if (nodeId != null && !nodeId.equals((Object)CNodeId.getLocal())) {
                CNodeAddress newNode = new CNodeAddress(nodeId, CSegmentId.getLocal());
                receiver = new CTargetAddress(IId.INVALID, IId.INVALID, nodeId, CSegmentId.getLocal());
                envelope.getReceivers().push(receiver);
                nextNode = this.mDependencies.getRouter().getNextNode(newNode, false);
            }
            if (nextNode == null) {
                LOG_TO_REMOTE.warn("Can't find Node {} in RoutingTable.", new Object[]{node});
                if (node.getSegmentId().isLocal()) {
                    envelope.setResult(5302, "Unknown destination node");
                    this.getMessageSender().sendBack(aMsg);
                    LOG_TO_REMOTE.warn("Couldn't send Message to Remote Node : Send back: {}", new Object[]{aMsg});
                } else {
                    this.forwardToLinkCollector(aMsg);
                }
                return;
            }
        }
        if ((entry = this.mConnectionList.getEntryForNode(nextNode)) == null) {
            throw new CException(5).append("next Node not found: ").append((Object)node);
        }
        ITransport transport = entry.getTransport();
        if (transport == null) {
            throw new CException(5).append("Transport not found.");
        }
        CTargetAddress transportAddress = transport.getAddress();
        if (transportAddress == null || !transportAddress.isValid()) {
            throw new CException(5).append("Transport not found.");
        }
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)transportAddress);
        env.setSender(this.getAddress());
        env.setLogEnabled(false);
        CRecord rec = new CRecord(CRecordNetworkSendToRemote.ID);
        CRecordNetworkSendToRemote.setMessage((CRecord)rec, (CMessage)aMsg);
        this.sendNotification(env, rec);
    }

    private void forwardToLinkCollector(@NotNull CMessage aMsg) throws CException {
        LOG_TO_REMOTE.debug("Forward Message to LinkCollector: {}", new Object[]{aMsg.getEnvelope()});
        CEnvelope env = CEnvelope.forMicroService((IId)de.sillysky.nyssr.link.collector.CConstants.MICRO_SERVICE_ID);
        env.setLogEnabled(false);
        CRecord record = CRecordLinkCollectorForwardToNextNode.create();
        CRecordLinkCollectorForwardToNextNode.setMessage((CRecord)record, (CMessage)aMsg);
        this.sendNotification(env, record);
    }

    private void sendNotifyConnectionRemoved(@NotNull CConnectionDto aConnection) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkNotifyConnectionDeregistered.class);
        CRecord innerRec = CConnectionUtil.toRecord(aConnection);
        CRecord outerRec = CRecordNetworkNotifyConnectionDeregistered.create();
        CRecordNetworkNotifyConnectionDeregistered.setConnection((CRecord)outerRec, (CRecord)innerRec);
        this.sendNotification(env, outerRec);
    }

    private void sendNotifyConnectionRegistered(@NotNull CConnectionDto aConnection) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkNotifyConnectionRegistered.class);
        CRecord innerRec = CConnectionUtil.toRecord(aConnection);
        CRecord outerRec = CRecordNetworkNotifyConnectionRegistered.create();
        CRecordNetworkNotifyConnectionRegistered.setConnection((CRecord)outerRec, (CRecord)innerRec);
        this.sendNotification(env, outerRec);
    }

    private void sendToLocal(@NotNull CConnectionDto aConnection, @NotNull CMessage aMsg) throws CException {
        IGateKeeper keeper = this.mGateKeeper.get();
        if (keeper != null) {
            CResult result;
            CEnvelope env = aMsg.getEnvelope();
            CRecord record = aMsg.getRecord();
            try {
                result = keeper.checkMessage(aConnection.getLocalPort(), env, record);
            }
            catch (Exception e) {
                result = new CResult(2).append("Exception on involving GateKeeper: ").append(e.getMessage());
                LOG.error(result.toString());
            }
            boolean drop = true;
            if (result == null || result.getCode() == 0) {
                drop = false;
            } else {
                CResult error;
                CNodeAddress node = env.getSender().getNodeAddress();
                if (!node.isLocalNode() && (error = env.swap()) == null) {
                    env.setResult(result);
                    drop = false;
                }
            }
            if (!drop) {
                try {
                    this.mDependencies.getMessageSender().send(env, record);
                }
                catch (CException e) {
                    env.setResult(e.getCode(), e.getMessage());
                    this.mDependencies.getMessageSender().sendBack(env, record);
                }
                catch (Exception e) {
                    env.setResult(2, e.getMessage());
                    this.mDependencies.getMessageSender().sendBack(env, record);
                }
            }
        } else {
            try {
                LOG.debug("Incoming Msg: {}", new Object[]{aMsg});
                this.mDependencies.getMessageSender().send(aMsg);
            }
            catch (CException e) {
                aMsg.getEnvelope().setResult(e.getCode(), e.getMessage());
                this.mDependencies.getMessageSender().sendBack(aMsg);
            }
            catch (Exception e) {
                aMsg.getEnvelope().setResult(2, e.getMessage());
                this.mDependencies.getMessageSender().sendBack(aMsg);
            }
        }
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.mConnectionList.size() + " connections";
    }

    private void sendAddCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{LIST_CONNECTIONS});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{HELP_LIST_CONNECTIONS});
        this.sendNotification(env, record);
    }
}

