/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.target;

import de.sillysky.nyssr.impl.network.index.IInternalNetworkIndex;
import de.sillysky.nyssr.impl.network.index.target.CNetworkIndexApiTarget;
import de.sillysky.nyssr.impl.network.index.target.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplNetworkIndexTarget
implements IServiceStarter,
IDependencies {
    private static final String FILTER = "nid=TRANSPORT";
    private IService mService;
    private INamespace mNamespace;
    private IInternalNetworkIndex mInternalNetworkIndex;
    private IRecordHelper mRecordHelper;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespace.class, FILTER);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(IInternalNetworkIndex.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespace = (INamespace)aServiceRegistry.getServiceOrThrow(INamespace.class, FILTER);
            this.mRecordHelper = (IRecordHelper)aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
            this.mInternalNetworkIndex = (IInternalNetworkIndex)aServiceRegistry.getServiceOrThrow(IInternalNetworkIndex.class);
            this.mService = new CNetworkIndexApiTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INamespace getNamespace() {
        return this.mNamespace;
    }

    @Override
    @NotNull
    public IRecordHelper getRecordHelper() {
        return this.mRecordHelper;
    }

    @Override
    @NotNull
    public IInternalNetworkIndex getInternalNetworkIndex() {
        return this.mInternalNetworkIndex;
    }
}

