/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.files.CResourceHandler;
import de.sillysky.nyssr.util.streamheader.CBasicStreamHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;

final class CStreamHeaderBasicMessage
extends CBasicStreamHeader<CPacketMessage> {
    private CNodeAddress mSource;
    private CNodeAddress mDestination;
    private String mBuilderSequence;
    private EPriority mPriority;

    CStreamHeaderBasicMessage(CPacketMessage aOwner) {
        super(1, (Object)aOwner, null);
    }

    CStreamHeaderBasicMessage(CPacketMessage aOwner, byte[] aBytes) {
        super(1, (Object)aOwner, aBytes);
    }

    String getBuilderSequence() {
        return this.mBuilderSequence;
    }

    void setBuilderSequence(String aSequence) {
        this.mBuilderSequence = aSequence;
    }

    CNodeAddress getDestination() {
        return this.mDestination;
    }

    void setDestination(CNodeAddress aDestination) {
        this.mDestination = aDestination;
    }

    EPriority getPriority() {
        return this.mPriority;
    }

    void setPriority(EPriority aPriority) {
        this.mPriority = aPriority;
    }

    CNodeAddress getSource() {
        return this.mSource;
    }

    void setSource(CNodeAddress aSource) {
        this.mSource = aSource;
    }

    public void pack() {
        if (this.getPackedData() != null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                this.registerResource(dos);
                dos.writeByte(CStreamHeaderBasicMessage.this.mPriority.getValue());
                dos.writeUTF(CStreamHeaderBasicMessage.this.mBuilderSequence);
                CNodeAddress.toStream((DataOutput)dos, (CNodeAddress)CStreamHeaderBasicMessage.this.mDestination);
                CNodeAddress.toStream((DataOutput)dos, (CNodeAddress)CStreamHeaderBasicMessage.this.mSource);
                dos.close();
                return baos.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        byte[] result = (byte[])handler.getResult();
        this.setPackedHeaderBytes(result);
    }

    void removeBuilderFlag(char aType) {
        int size = this.mBuilderSequence.length();
        char charAt = this.mBuilderSequence.charAt(size - 1);
        if (charAt == aType) {
            this.mBuilderSequence = this.mBuilderSequence.substring(0, size - 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(": from ");
        sb.append(this.mSource);
        sb.append(" to ");
        sb.append(this.mDestination);
        sb.append(" ");
        if (this.mBuilderSequence.indexOf(77) >= 0) {
            sb.append(" prio=");
            sb.append(this.getPriority());
            sb.append(" ");
        }
        sb.append(this.mBuilderSequence);
        return sb.toString();
    }

    public void unpack() {
        final byte[] packedData = this.getPackedData();
        if (packedData == null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(this){
            final /* synthetic */ CStreamHeaderBasicMessage this$0;
            {
                this.this$0 = this$0;
            }

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayInputStream bais = new ByteArrayInputStream(packedData);
                DataInputStream dis = new DataInputStream(bais);
                this.registerResource(dis);
                byte prio = dis.readByte();
                this.this$0.mPriority = EPriority.getSave((int)prio);
                this.this$0.mBuilderSequence = dis.readUTF();
                this.this$0.mDestination = CNodeAddress.fromStream((DataInput)dis);
                this.this$0.mSource = CNodeAddress.fromStream((DataInput)dis);
                return null;
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
    }
}

