/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.message;

import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.files.CResourceHandler;
import de.sillysky.nyssr.util.streamheader.CBasicStreamHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.Adler32;

final class CStreamHeaderMessagePayload
extends CBasicStreamHeader<CPacketMessage> {
    private final boolean mUseAdler;
    private byte[] mPayload;

    CStreamHeaderMessagePayload(CPacketMessage aOwner) {
        super(2, (Object)aOwner, null);
        this.mUseAdler = false;
    }

    CStreamHeaderMessagePayload(CPacketMessage aOwner, byte[] aBytes) {
        super(2, (Object)aOwner, aBytes);
        this.mUseAdler = false;
    }

    private int getAdler(byte[] aData) {
        Adler32 adler = new Adler32();
        adler.update(aData, 0, aData.length);
        return (int)adler.getValue();
    }

    byte[] getPayload() {
        return this.mPayload;
    }

    void setPayload(byte[] aPayload) {
        this.mPayload = aPayload;
    }

    public void pack() {
        if (this.getPackedData() != null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                this.registerResource(dos);
                if (CStreamHeaderMessagePayload.this.mPayload == null) {
                    CPositiveInteger.toStream((DataOutput)dos, (int)0);
                } else {
                    CPositiveInteger.toStream((DataOutput)dos, (int)CStreamHeaderMessagePayload.this.mPayload.length);
                    if (CStreamHeaderMessagePayload.this.mUseAdler) {
                        int adler = CStreamHeaderMessagePayload.this.getAdler(CStreamHeaderMessagePayload.this.mPayload);
                        dos.writeInt(adler);
                    }
                    dos.write(CStreamHeaderMessagePayload.this.mPayload);
                }
                dos.close();
                return baos.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        byte[] result = (byte[])handler.getResult();
        this.setPackedHeaderBytes(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        if (this.mPayload != null) {
            sb.append(" length=");
            sb.append(this.mPayload.length);
        } else {
            byte[] packedData = this.getPackedData();
            if (packedData != null) {
                sb.append(" packedMessage=");
                sb.append(packedData.length);
            }
        }
        return sb.toString();
    }

    public void unpack() {
        final byte[] packedData = this.getPackedData();
        if (packedData == null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(this){
            final /* synthetic */ CStreamHeaderMessagePayload this$0;
            {
                this.this$0 = this$0;
            }

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayInputStream bais = new ByteArrayInputStream(packedData);
                DataInputStream dis = new DataInputStream(bais);
                this.registerResource(dis);
                int payloadSize = CPositiveInteger.fromStream((DataInput)dis);
                if (payloadSize > 0) {
                    int result;
                    int adlerHeader = 0;
                    if (this.this$0.mUseAdler) {
                        adlerHeader = dis.readInt();
                    }
                    byte[] data = new byte[payloadSize];
                    int read = 0;
                    do {
                        if ((result = dis.read(data, read, data.length - read)) >= 0) continue;
                        throw new IOException();
                    } while ((read += result) < data.length);
                    if (this.this$0.mUseAdler) {
                        Adler32 a32 = new Adler32();
                        a32.update(data, 0, data.length);
                        int adler2 = (int)a32.getValue();
                        if (adlerHeader == adler2) {
                            return data;
                        }
                    } else {
                        return data;
                    }
                }
                return null;
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        this.mPayload = (byte[])handler.getResult();
    }
}

