/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.network.router.CDijkstraLink;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkList;
import de.sillysky.nyssr.record.CRecord;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CUtilLinkList {
    private CUtilLinkList() {
    }

    @Nullable
    static CRecord createRecordWithCosts(@NotNull List<CDijkstraLink> aLinks) throws CException {
        ArrayList<CRecord> records = new ArrayList<CRecord>();
        for (CDijkstraLink link : aLinks) {
            CRecord record = link.toRecord();
            records.add(record);
        }
        if (!records.isEmpty()) {
            CRecord[] array = records.toArray(new CRecord[0]);
            CRecord record = CRecordNetworkLinkList.create();
            CRecordNetworkLinkList.setLinks((CRecord)record, (CRecord[])array);
            return record;
        }
        return null;
    }

    @NotNull
    static List<CDijkstraLink> fromRecord(@NotNull CRecord aRecord) throws CException {
        CUtilLinkList.checkRecordId(aRecord);
        ArrayList<CDijkstraLink> list = new ArrayList<CDijkstraLink>();
        CRecord[] linkRecords = CRecordNetworkLinkList.getLinks((CRecord)aRecord, null);
        if (linkRecords != null) {
            for (CRecord linkRecord : linkRecords) {
                CDijkstraLink link = CDijkstraLink.fromRecord((CRecord)linkRecord);
                list.add(link);
            }
        }
        return list;
    }

    private static void checkRecordId(@NotNull CRecord aARecord) throws CException {
        if (!CRecordNetworkLinkList.ID.equals((Object)aARecord.getId())) {
            throw new CException(2010);
        }
    }
}

