/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkData;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CDijkstraLink {
    private static final ILogger LOG_COSTS = CLoggerFactory.getLogger((String)"network.costs");
    private static final byte HEADER = -1;
    private final CNodeAddress mNodeAddress1;
    private final CNodeAddress mNodeAddress2;
    private ZonedDateTime mCostMeasureTime;
    private int mCosts;

    @NotNull
    public static CDijkstraLink fromRecord(@NotNull CRecord aRecord) throws CException {
        CUtilCheck.checkEqualEx((Object)aRecord.getId(), (Object)CRecordNetworkLinkData.ID, (String)"", (Object[])new Object[0]);
        CNodeAddress node1 = CRecordNetworkLinkData.getNode1(aRecord, null);
        CNodeAddress node2 = CRecordNetworkLinkData.getNode2(aRecord, null);
        int costs = CRecordNetworkLinkData.getCosts(aRecord, 0);
        ZonedDateTime timestamp = CRecordNetworkLinkData.getCostMeasureTime(aRecord, ZonedDateTime.now());
        return new CDijkstraLink(node1, node2, timestamp, costs);
    }

    public CDijkstraLink(CNodeAddress aNode1, CNodeAddress aNode2, ZonedDateTime aCostMeasureTime, int aCosts) {
        if (aNode1.compareTo(aNode2) < 0) {
            this.mNodeAddress1 = aNode1;
            this.mNodeAddress2 = aNode2;
        } else {
            this.mNodeAddress1 = aNode2;
            this.mNodeAddress2 = aNode1;
        }
        this.mCosts = aCosts;
        this.mCostMeasureTime = aCostMeasureTime;
    }

    @Nullable
    public static CDijkstraLink fromStream(@NotNull DataInput aStream) throws IOException {
        for (int i = 0; i < 2; ++i) {
            byte header = aStream.readByte();
            if (header == -1) continue;
            throw new IOException("Missing Link Header 0xFF");
        }
        CNodeAddress nodeAddress1 = CNodeAddress.fromStream((DataInput)aStream);
        CNodeAddress nodeAddress2 = CNodeAddress.fromStream((DataInput)aStream);
        ZonedDateTime timestamp = CUtilZonedDateTime.fromStream((DataInput)aStream);
        int costs = CPositiveInteger.fromStream((DataInput)aStream);
        if (nodeAddress1 != null && nodeAddress2 != null) {
            return new CDijkstraLink(nodeAddress1, nodeAddress2, timestamp, costs);
        }
        return null;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null) {
            return false;
        }
        if (this.getClass() != aOther.getClass()) {
            return false;
        }
        CDijkstraLink other = (CDijkstraLink)aOther;
        if (CNodeAddress.logicalEquals((CNodeAddress)this.mNodeAddress1, (CNodeAddress)other.mNodeAddress1) && CNodeAddress.logicalEquals((CNodeAddress)this.mNodeAddress2, (CNodeAddress)other.mNodeAddress2)) {
            return true;
        }
        return CNodeAddress.logicalEquals((CNodeAddress)this.mNodeAddress1, (CNodeAddress)other.mNodeAddress2) && CNodeAddress.logicalEquals((CNodeAddress)this.mNodeAddress2, (CNodeAddress)other.mNodeAddress1);
    }

    public int getCosts() {
        return this.mCosts;
    }

    public CNodeAddress getNode1() {
        return this.mNodeAddress2;
    }

    public CNodeAddress getNode2() {
        return this.mNodeAddress1;
    }

    public ZonedDateTime getCostMeasureTime() {
        return this.mCostMeasureTime;
    }

    public int hashCode() {
        return this.mNodeAddress1 == null ? 0 : this.mNodeAddress1.hashCode() + (this.mNodeAddress2 == null ? 0 : this.mNodeAddress2.hashCode());
    }

    public void toStream(@NotNull DataOutput aStream) throws IOException {
        for (int i = 0; i < 2; ++i) {
            aStream.writeByte(-1);
        }
        CNodeAddress.toStream((DataOutput)aStream, (CNodeAddress)this.mNodeAddress1);
        CNodeAddress.toStream((DataOutput)aStream, (CNodeAddress)this.mNodeAddress2);
        CUtilZonedDateTime.toStream((DataOutput)aStream, (ZonedDateTime)this.mCostMeasureTime);
        CPositiveInteger.toStream((DataOutput)aStream, (int)this.mCosts);
    }

    public String toString() {
        return this.mNodeAddress1 + "<---" + this.mCosts + "--->" + this.mNodeAddress2;
    }

    public boolean update(@NotNull CDijkstraLink aLink) {
        boolean result = false;
        if (aLink.mCostMeasureTime.isAfter(this.mCostMeasureTime)) {
            this.mCostMeasureTime = aLink.mCostMeasureTime;
            int newCosts = aLink.getCosts();
            if (newCosts != this.mCosts) {
                this.mCosts = newCosts;
                result = true;
            }
        }
        return result;
    }

    public boolean updateCosts(int aCosts, ZonedDateTime aTimestamp) {
        boolean updated = false;
        if (aTimestamp.isAfter(this.mCostMeasureTime) && aCosts != this.mCosts) {
            LOG_COSTS.debug("Router: Update costs: {} -- {} -- {} {}", new Object[]{this.mNodeAddress1, aCosts, this.mNodeAddress2, "Fixed?"});
            this.mCosts = aCosts;
            this.mCostMeasureTime = aTimestamp;
            updated = true;
        }
        return updated;
    }

    @NotNull
    public CRecord toRecord() throws CException {
        CRecord record = CRecordNetworkLinkData.create();
        CRecordNetworkLinkData.setNode1(record, this.mNodeAddress1);
        CRecordNetworkLinkData.setNode2(record, this.mNodeAddress2);
        CRecordNetworkLinkData.setCosts(record, this.mCosts);
        CRecordNetworkLinkData.setCostMeasureTime(record, this.mCostMeasureTime);
        return record;
    }
}

