/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.router.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkLinkList
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"0de40305-9503-4b1d-ab5b-c7cae98e2a42");
    public static final String NAME = "NetworkLinkList";
    public static final String DESCRIPTION = "Data record: links and their costs.";
    public static final String SLOT_COSTS = "4";
    public static final String SLOT_COST_MEASURE_TIMES = "5";
    public static final String SLOT_FIRST_IS_SERVER = "7";
    public static final String SLOT_NODE_ADDRESSES = "1";
    public static final String SLOT_NODE_INDEX1 = "2";
    public static final String SLOT_NODE_INDEX2 = "3";
    public static final String SLOT_TIME_OF_CREATION = "6";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static int[] getCosts(@NotNull CRecord aRecord, int[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COSTS);
        if (slot == null) {
            return aDefault;
        }
        return (int[])slot.getValue();
    }

    public static ZonedDateTime[] getCostMeasureTimes(@NotNull CRecord aRecord, ZonedDateTime[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COST_MEASURE_TIMES);
        if (slot == null) {
            return aDefault;
        }
        return (ZonedDateTime[])slot.getValue();
    }

    public static boolean[] getFirstIsServer(@NotNull CRecord aRecord, boolean[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FIRST_IS_SERVER);
        if (slot == null) {
            return aDefault;
        }
        return (boolean[])slot.getValue();
    }

    public static CNodeAddress[] getNodeAddresses(@NotNull CRecord aRecord, CNodeAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE_ADDRESSES);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress[])slot.getValue();
    }

    public static int[] getNodeIndex1(@NotNull CRecord aRecord, int[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE_INDEX1);
        if (slot == null) {
            return aDefault;
        }
        return (int[])slot.getValue();
    }

    public static int[] getNodeIndex2(@NotNull CRecord aRecord, int[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE_INDEX2);
        if (slot == null) {
            return aDefault;
        }
        return (int[])slot.getValue();
    }

    public static ZonedDateTime[] getTimeOfCreation(@NotNull CRecord aRecord, ZonedDateTime[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME_OF_CREATION);
        if (slot == null) {
            return aDefault;
        }
        return (ZonedDateTime[])slot.getValue();
    }

    public static void setCosts(@NotNull CRecord aRecord, int[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_COSTS, slot);
    }

    public static void setCostMeasureTimes(@NotNull CRecord aRecord, ZonedDateTime[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ZONED_DATE_TIME_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_COST_MEASURE_TIMES, slot);
    }

    public static void setFirstIsServer(@NotNull CRecord aRecord, boolean[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_FIRST_IS_SERVER, slot);
    }

    public static void setNodeAddresses(@NotNull CRecord aRecord, CNodeAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NODE_ADDRESSES, slot);
    }

    public static void setNodeIndex1(@NotNull CRecord aRecord, int[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NODE_INDEX1, slot);
    }

    public static void setNodeIndex2(@NotNull CRecord aRecord, int[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NODE_INDEX2, slot);
    }

    public static void setTimeOfCreation(@NotNull CRecord aRecord, ZonedDateTime[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ZONED_DATE_TIME_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_TIME_OF_CREATION, slot);
    }
}

