/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dev.check;

import de.sillysky.nyssr.impl.dev.check.CDevCheckTarget;
import de.sillysky.nyssr.impl.dev.check.IDependencies;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public class CPackageImplDevCheck
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INamespaceRegistry mNamespaceRegistry;
    private ITimerManager mTimerManager;
    private INameDb mNameDb;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceRegistry.class);
        aDependencyList.add(ITimerManager.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IRouter.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespaceRegistry = (INamespaceRegistry)aServiceRegistry.getServiceOrThrow(INamespaceRegistry.class);
            this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mService = new CDevCheckTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INamespaceRegistry getNamespaceRegistry() {
        return this.mNamespaceRegistry;
    }

    @Override
    @NotNull
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }
}

