/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.link.collector.records;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordLinkCollectorGetNextHop
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"de6eec48-3e30-44e3-83ec-a9fbc01b3c56");
    public static final String NAME = "LinkCollectorGetNextHop";
    public static final String DESCRIPTION = "Get the next hop for a given destination";
    public static final String SLOT_DESTINATION = "1";
    public static final String SLOT_HOP = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CSegmentId getDestination(@NotNull CRecord aRecord, CSegmentId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DESTINATION);
        if (slot == null) {
            return aDefault;
        }
        return (CSegmentId)slot.getValue();
    }

    public static CNodeId getHop(@NotNull CRecord aRecord, CNodeId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HOP);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeId)slot.getValue();
    }

    public static void setDestination(@NotNull CRecord aRecord, CSegmentId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.SEGMENT_ID, (Object)aValue);
        aRecord.addSlot(SLOT_DESTINATION, slot);
    }

    public static void setHop(@NotNull CRecord aRecord, CNodeId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ID, (Object)aValue);
        aRecord.addSlot(SLOT_HOP, slot);
    }
}

