/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.tcp.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordTcpNotifyServerCreated
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"01fb4d5b-7181-4128-892e-c5c9199eb92e");
    public static final String NAME = "TcpNotifyServerCreated";
    public static final String DESCRIPTION = "Notification that a TCP server has been created.";
    public static final String SLOT_ID = "1";
    public static final String SLOT_PORT = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static int getPort(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PORT);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setPort(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_PORT, slot);
    }
}

