/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.costs;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.costs.CCostEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordAddLinkCosts;
import de.sillysky.nyssr.record.CRecord;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CCostList {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.costs");
    private final Map<CNodeId, CCostEntry> mCosts = new HashMap<CNodeId, CCostEntry>();

    CCostList() {
    }

    void add(@NotNull CNodeId aNodeId, int aCosts) {
        CCostEntry entry = this.mCosts.get(aNodeId);
        if (entry == null) {
            entry = new CCostEntry(aNodeId);
            this.mCosts.put(aNodeId, entry);
        }
        entry.addCosts(aCosts);
    }

    void remove(@NotNull CNodeId aNodeId) {
        this.mCosts.remove(aNodeId);
    }

    @Nullable
    CRecord toRecord() throws CException {
        int size = this.mCosts.size();
        if (size > 0) {
            CNodeId[] localNodes = new CNodeId[size];
            CNodeId[] nodes = new CNodeId[size];
            int[] costs = new int[size];
            int i = 0;
            for (CCostEntry entry : this.mCosts.values()) {
                localNodes[i] = CNodeId.getLocal();
                nodes[i] = entry.getNode();
                costs[i] = entry.getAverage();
                LOG.debug("Send local link cost entry: average={} of {} by {} records", new Object[]{costs[i], nodes[i], entry.getRecordCount()});
                entry.reset();
                ++i;
            }
            CRecord record = CRecordAddLinkCosts.create();
            CRecordAddLinkCosts.setNode1((CRecord)record, (CNodeId[])localNodes);
            CRecordAddLinkCosts.setNode2((CRecord)record, (CNodeId[])nodes);
            CRecordAddLinkCosts.setCosts((CRecord)record, (int[])costs);
            return record;
        }
        return null;
    }
}

