/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.consumer.ping;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.factory.ping.CPacketPing;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketConsumerRegistry;
import de.sillysky.nyssr.network.packets.IPacketContext;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.network.packets.IPacketTypeConsumer;
import de.sillysky.nyssr.network.records.CRecordNetworkRouterPing;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import org.jetbrains.annotations.NotNull;

final class CPacketConsumerPing
implements IPacketTypeConsumer,
IService {
    private static final ILogger LOG_PACKET = CLoggerFactory.getLogger((String)"network.ping");

    CPacketConsumerPing() {
    }

    public static void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IPacketConsumerRegistry.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketConsumerRegistry packetConsumerRegistry = (IPacketConsumerRegistry)aServiceRegistry.getService(IPacketConsumerRegistry.class);
        assert (packetConsumerRegistry != null);
        packetConsumerRegistry.registerPacketConsumer(this);
    }

    @Override
    public void consumePacket(@NotNull IPacketContext aContext, @NotNull IPacket aPacket) throws CException {
        CPacketPing packet = (CPacketPing)aPacket;
        long time = packet.getTimeSend();
        long now = System.nanoTime();
        LOG_PACKET.trace("Ping Answer={}, time={}, now={}", new Object[]{packet.isAnswer(), time, now});
        if (!packet.isAnswer()) {
            this.sendPingAnswer(aContext, time);
        } else {
            this.incomingPingForTransport(aContext, time);
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketConsumerRegistry packetConsumerRegistry = (IPacketConsumerRegistry)aServiceRegistry.getService(IPacketConsumerRegistry.class);
        if (packetConsumerRegistry != null) {
            packetConsumerRegistry.deregisterPacketConsumer(this);
        }
    }

    @Override
    @NotNull
    public EPacketType getType() {
        return EPacketType.PING;
    }

    private void incomingPingForTransport(IPacketContext aContext, Long aTime) throws CException {
        CTargetAddress address = aContext.getPingTargetAddress();
        if (address != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord rec = CRecordNetworkRouterPing.create();
            CRecordNetworkRouterPing.setTimestamp((CRecord)rec, (long)aTime);
            aContext.getTarget().sendNotification(env, rec);
        }
    }

    private void sendPingAnswer(@NotNull IPacketContext aContext, long aTime) throws CException {
        IPacketFactory factory = aContext.getPacketFactoryRegistry().getPacketFactory(EPacketType.PING);
        if (factory != null) {
            CPacketPing packet = new CPacketPing(true, aTime);
            packet.pack();
            aContext.sendPacketToTransportLayer(packet, false);
        }
    }
}

