/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.stream.hook;

import de.sillysky.nyssr.network.stream.hook.IStreamMonitor;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CByteArrayDumper
implements IStreamMonitor {
    private static final int MAX_BYTES_PER_LINE = 20;
    private static final int HIGH_NIBBLE = 240;
    private static final int LOW_NIBBLE = 15;
    private static final int BITS_NIBBLE = 4;
    private static final int BYTES_IN_ROW = 5;
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private final StringBuffer mSb = new StringBuffer(100);
    private final DataOutputStream mStream;
    private boolean isTx = false;
    private int mLinePos = 0;

    CByteArrayDumper(OutputStream aStream) {
        this.mStream = new DataOutputStream(aStream);
    }

    private void print(byte[] aArray, int aOffset, int aLength, String aText) {
        if (aArray != null && aArray.length > 0) {
            for (int i = 0; i < aArray.length; ++i) {
                if (this.mLinePos == 20) {
                    this.print(aText, this.mSb.toString());
                    this.println();
                    this.mSb.delete(0, this.mSb.length());
                    this.mLinePos = 1;
                    this.mSb.append(" ");
                } else {
                    this.mSb.append(" ");
                    if (this.mLinePos > 0 && this.mLinePos % 5 == 0) {
                        this.mSb.append(" - ");
                    }
                    ++this.mLinePos;
                }
                byte ch = (byte)(aArray[i] & 0xF0);
                ch = (byte)(ch >>> 4);
                ch = (byte)(ch & 0xF);
                this.mSb.append(HEX_CHARS.charAt(ch));
                ch = (byte)(aArray[i] & 0xF);
                this.mSb.append(HEX_CHARS.charAt(ch));
            }
        }
    }

    private void print(String aPre, String aData) {
        try {
            this.mStream.writeBytes(aPre);
            this.mStream.writeBytes(":");
            this.mStream.writeBytes(aData);
            this.mStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void println() {
        try {
            this.mStream.writeBytes(CUtilString.CRLF);
            this.mStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void println(String aText) {
        try {
            this.mStream.writeBytes(aText);
            this.mStream.writeBytes(CUtilString.CRLF);
            this.mStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void rx(byte[] aData, int aOffset, int aLength) {
        if (this.isTx) {
            this.isTx = false;
            if (this.mSb.length() > 0) {
                this.print("TX", this.mSb.toString());
                this.println();
                this.mSb.delete(0, this.mSb.length());
            }
            this.println(CUtilString.LINE_CRLF);
            this.mLinePos = 0;
        }
        this.print(aData, aOffset, aLength, "RX");
    }

    public synchronized void tx(byte[] aData, int aOffset, int aLength) {
        if (!this.isTx) {
            this.isTx = true;
            if (this.mSb.length() > 0) {
                this.print("RX", this.mSb.toString());
                this.println();
                this.mSb.delete(0, this.mSb.length());
            }
            this.println(CUtilString.LINE_CRLF);
            this.mLinePos = 0;
        }
        this.print(aData, aOffset, aLength, "TX");
    }
}

