/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.connection.dto;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.network.connection.dto.EConnectionUsage;
import de.sillysky.nyssr.network.connection.records.EConnectionType;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CConnectionDto {
    private final UUID mID;
    private final LocalDateTime mTimeStarted;
    private EConnectionType mType;
    private boolean mIncoming;
    private CTargetAddress mConnectionAddress;
    private String mLocalAddress;
    private int mLocalPort;
    private EConnectionUsage mUsage = EConnectionUsage.UNKNOWN;
    private String mRemoteAddress;
    private CNodeAddress mRemoteNodeAddress;
    private UUID mRemoteInstanceID;

    public CConnectionDto(@NotNull UUID aID) {
        this.mID = aID;
        this.mTimeStarted = LocalDateTime.now();
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CConnectionDto that = (CConnectionDto)aO;
        return this.mID.equals(that.mID);
    }

    @Nullable
    public CTargetAddress getConnectionAddress() {
        return this.mConnectionAddress;
    }

    public void setConnectionAddress(@Nullable CTargetAddress aConnectionAddress) {
        this.mConnectionAddress = aConnectionAddress;
    }

    @NotNull
    public UUID getID() {
        return this.mID;
    }

    @Nullable
    public String getLocalAddress() {
        return this.mLocalAddress;
    }

    public void setLocalAddress(@Nullable String aLocalAddress) {
        this.mLocalAddress = aLocalAddress;
    }

    public int getLocalPort() {
        return this.mLocalPort;
    }

    public void setLocalPort(int aLocalPort) {
        this.mLocalPort = aLocalPort;
    }

    @Nullable
    public String getRemoteAddress() {
        return this.mRemoteAddress;
    }

    public void setRemoteAddress(@Nullable String aRemoteAddress) {
        this.mRemoteAddress = aRemoteAddress;
    }

    @Nullable
    public UUID getRemoteInstanceID() {
        return this.mRemoteInstanceID;
    }

    public void setRemoteInstanceID(@Nullable UUID aRemoteInstanceID) {
        this.mRemoteInstanceID = aRemoteInstanceID;
    }

    @Nullable
    public CNodeAddress getRemoteNodeAddress() {
        return this.mRemoteNodeAddress;
    }

    public void setRemoteNodeAddress(@Nullable CNodeAddress aRemoteNodeAddress) {
        this.mRemoteNodeAddress = aRemoteNodeAddress;
    }

    @NotNull
    public EConnectionType getType() {
        return this.mType;
    }

    public void setType(@NotNull EConnectionType aType) {
        this.mType = aType;
    }

    @NotNull
    public EConnectionUsage getUsage() {
        return this.mUsage;
    }

    public void setUsage(@NotNull EConnectionUsage aUsage) {
        this.mUsage = aUsage;
    }

    public int hashCode() {
        return this.mID.hashCode();
    }

    public boolean isIncoming() {
        return this.mIncoming;
    }

    public void setIncoming(boolean aIncoming) {
        this.mIncoming = aIncoming;
    }

    public String toString() {
        if (this.mRemoteAddress == null) {
            return "Local Machine";
        }
        return this.getID() + " from " + this.mRemoteAddress;
    }

    public LocalDateTime getTimeStarted() {
        return this.mTimeStarted;
    }
}

