/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.user.manager;

import de.sillysky.nyssr.impl.app.user.manager.CAppFactory;
import de.sillysky.nyssr.impl.app.user.manager.IDependencies;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContextFactory;
import de.sillysky.nyssr.remoteskin.server.widgetset.loader.IWidgetSetLoader;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplAppUserManager
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INamespaceFactory mNamespaceFactory;
    private IRemoteSkinServerContextFactory mRemoteSkinServerContextFactory;
    private IWidgetSetLoader mWidgetSetLoader;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IRemoteSkinServerContextFactory.class);
        aDependencyList.add(IWidgetSetLoader.class);
        aDependencyList.add(IMicroServiceRegistryCollector.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mRemoteSkinServerContextFactory = (IRemoteSkinServerContextFactory)aServiceRegistry.getServiceOrThrow(IRemoteSkinServerContextFactory.class);
            this.mWidgetSetLoader = (IWidgetSetLoader)aServiceRegistry.getServiceOrThrow(IWidgetSetLoader.class);
            this.mService = new CAppFactory(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    public IRemoteSkinServerContextFactory getServerContextFactory() {
        return this.mRemoteSkinServerContextFactory;
    }

    @Override
    public IWidgetSetLoader getWidgetSetLoader() {
        return this.mWidgetSetLoader;
    }
}

