/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.user.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.dialog.user.CConstantsDialogUser;
import de.sillysky.nyssr.dialog.user.records.CRecordOpenDialogUser;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.app.user.manager.ILocalAppContext;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CUtilDialogHelper;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordCloseDialog;
import de.sillysky.nyssr.target.ITarget;
import org.jetbrains.annotations.NotNull;

class CUserDialogHolder {
    private ILocalAppContext mLocalAppContext;
    private ITarget mTarget;
    private CTargetAddress mAddressOfUserDialog;

    CUserDialogHolder(@NotNull ILocalAppContext aLocalAppContext, @NotNull ITarget aTarget) {
        this.mLocalAppContext = aLocalAppContext;
        this.mTarget = aTarget;
    }

    CTargetAddress getAddressOfUserDialog() {
        return this.mAddressOfUserDialog;
    }

    void setAddressOfUserDialog(CTargetAddress aAddressOfUserDialog) {
        this.mAddressOfUserDialog = aAddressOfUserDialog;
    }

    void show(CWidgetId aParentWidgetId, CTargetAddress aAddressOfMessagePanel) throws CException {
        IRemoteSkinClientContext clientContext = this.mLocalAppContext.getClientContext();
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsDialogUser.MICRO_SERVICE_ID);
        CRecord record = CRecordOpenDialogUser.create();
        CUtilDialogHelper.enrichOpenDialogRecord((CRecord)record, (IRemoteSkinClientContext)clientContext, (CWidgetId)aParentWidgetId, (String)this.mLocalAppContext.getApplicationContext().getSessionToken());
        this.mTarget.sendRequest(env, record);
    }

    private void close() throws CException {
        if (this.mAddressOfUserDialog != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mAddressOfUserDialog);
            CRecord record = CRecordCloseDialog.create();
            this.mTarget.sendNotification(env, record);
            this.mAddressOfUserDialog = null;
        }
    }

    void deactivate() throws CException {
        this.close();
        this.mTarget = null;
        this.mLocalAppContext = null;
    }
}

