/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.registry.helper;

import de.sillysky.nyssr.id.IId;
import java.util.Arrays;

final class CGeneratedRecord {
    private final IId mSID;
    private final String mName;
    private final IId[] mNamespaceIDs;
    private final boolean mForAllNamespaces;

    CGeneratedRecord(IId aSID, String aName) {
        this.mSID = aSID;
        this.mName = aName;
        this.mNamespaceIDs = null;
        this.mForAllNamespaces = true;
    }

    CGeneratedRecord(IId aSID, String aName, IId[] aNamespaceIDs) {
        this.mSID = aSID;
        this.mName = aName;
        this.mNamespaceIDs = aNamespaceIDs;
        this.mForAllNamespaces = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CGeneratedRecord other = (CGeneratedRecord)obj;
        if (this.mSID == null) {
            return other.mSID == null;
        }
        return this.mSID.equals(other.mSID);
    }

    String getName() {
        return this.mName;
    }

    IId[] getNamespaceIDs() {
        return this.mNamespaceIDs;
    }

    IId getSID() {
        return this.mSID;
    }

    boolean hasNID(IId aNID) {
        if (this.mForAllNamespaces) {
            return true;
        }
        assert (this.mNamespaceIDs != null);
        for (IId nid : this.mNamespaceIDs) {
            if (!nid.equals(aNID)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mSID == null ? 0 : this.mSID.hashCode());
        return result;
    }

    boolean isForAllNamespaces() {
        return this.mForAllNamespaces;
    }

    public String toString() {
        return "CGeneratedRecord [mSID=" + this.mSID + ", mName=" + this.mName + ", mNamespaceIDs=" + Arrays.toString(this.mNamespaceIDs) + ", mForAllNamespaces=" + this.mForAllNamespaces + "]";
    }
}

