/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringProperty;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotStringProperty
implements ISlot,
ISingleSlotTypeFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSlotStringProperty.class);
    private final CStringProperty mValue;

    public CSlotStringProperty() {
        this.mValue = null;
    }

    private CSlotStringProperty(CStringProperty aValue) {
        this.mValue = aValue;
    }

    private static CSlotStringProperty create(Object aValue) {
        Object o;
        List list;
        CSlotStringProperty result = null;
        if (aValue == null) {
            result = new CSlotStringProperty();
        } else if (aValue instanceof CStringProperty) {
            result = new CSlotStringProperty((CStringProperty)aValue);
        } else if (aValue instanceof String) {
            try {
                CStringProperty sp = new CStringProperty((String)aValue);
                result = new CSlotStringProperty(sp);
            }
            catch (CException e) {
                LOG.error("Error creating StringProperty from {}", aValue);
            }
        } else if (aValue instanceof List && !(list = (List)aValue).isEmpty() && (o = list.get(0)) instanceof String) {
            try {
                CStringProperty sp = new CStringProperty((String)o);
                result = new CSlotStringProperty(sp);
            }
            catch (CException e) {
                LOG.error("Error creating StringProperty from {}", aValue);
            }
        }
        return result;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotStringProperty fromStream(@NotNull DataInput aStream) throws IOException {
        boolean exist = aStream.readBoolean();
        if (exist) {
            return new CSlotStringProperty();
        }
        CStringProperty value = CStringProperty.fromStream(aStream);
        return new CSlotStringProperty(value);
    }

    @Override
    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSlotStringProperty that = (CSlotStringProperty)aO;
        return Objects.equals(this.mValue, that.mValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotStringProperty.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CStringProperty p;
        if (aValue instanceof CJsonObject && (p = CUtilJsonStringProperty.fromJson(aValue)) != null) {
            return new CSlotStringProperty(p);
        }
        return null;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CStringProperty.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        if (this.mValue == null) {
            return new CSlotStringProperty();
        }
        CStringProperty sp = new CStringProperty(this.mValue);
        return new CSlotStringProperty(sp);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.STRING_PROPERTY;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        if (aValue == null) {
            return this.mValue == null;
        }
        if (this.mValue != null) {
            return this.mValue.equals(aValue);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotStringProperty.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        if (this.mValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            this.mValue.toStream(aStream);
        }
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return this.mValue == null ? "null" : this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue != null) {
            return this.mValue.valueToString();
        }
        return null;
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null) {
            return CUtilJsonStringProperty.toJson(this.mValue);
        }
        return null;
    }
}

