/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.listener.target;

import de.sillysky.nyssr.impl.target.listener.target.CTargetForListenerRegistry;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import org.jetbrains.annotations.NotNull;

public final class CPackageTargetListenerTarget
implements IServiceStarter {
    private static final String FILTER = "nid=SYSTEM";
    private CTargetForListenerRegistry mTarget;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aList) {
        aList.add(INameDb.class);
        aList.add(IListenerRegistry.class);
        aList.add(IRecordHelper.class);
        aList.add(ITargetRegistry.class, FILTER);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mTarget == null) {
            INameDb nameDb = aServiceRegistry.getService(INameDb.class);
            IListenerRegistry listenerRegistry = aServiceRegistry.getService(IListenerRegistry.class);
            IRecordHelper recordHelper = aServiceRegistry.getService(IRecordHelper.class);
            ITargetRegistry targetRegistry = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
            this.mTarget = new CTargetForListenerRegistry(targetRegistry, nameDb, recordHelper, listenerRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mTarget != null) {
            this.mTarget.deactivate();
            this.mTarget = null;
        }
    }
}

