/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.util;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.time.CUtilInstant;
import java.time.Instant;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonEnvelopeUtil {
    public static final String KEY_PACKET_BUILDER_SEQUENCE = "packetBuilderSequence";
    public static final String KEY_SEQUENCE_NUMBER = "sequenceNumber";
    private static final String KEY_INSTANCE = "instance";
    private static final String KEY_LOG_ENABLED = "logEnabled";
    private static final String KEY_TIME_DELIVER = "timeDeliver";
    private static final String KEY_TIME_SEND = "timeSend";
    private static final String KEY_TIME_DELIVER_ANSWER = "timeDeliverAnswer";
    private static final String KEY_TIME_SEND_BACK = "timeSendBack";
    private static final String KEY_WANT_ANSWER = "wantAnswer";
    private static final String KEY_IS_ANSWER = "isAnswer";
    private static final String KEY_RESULT_TEXT = "resultText";
    private static final String KEY_RESULT_CODE = "resultCode";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String KEY_VERSION = "version";
    private static final String KEY_IS_NANO_SERVICE_MESSAGE = "isNanoService";
    private static final String KEY_PRIORITY = "priority";
    private static final String KEY_RECEIVER = "receiver";
    private static final String KEY_SENDER = "sender";
    private static final String KEY_ROUTING_HINT = "routingHint";
    private static final String KEY_ROUTING_HINT_CLIENT_ADDRESS = "client";
    private static final String KEY_ROUTING_HINT_BRIDGE_NODE_ID = "bridge";

    private CJsonEnvelopeUtil() {
    }

    @Nullable
    public static Object toJson(@Nullable CEnvelope aEnvelope) {
        if (aEnvelope != null) {
            CJsonObject jo = new CJsonObject(true);
            CJsonEnvelopeUtil.addressesToJson(aEnvelope);
        }
        return null;
    }

    @NotNull
    public static CJsonObject addressesToJson(@NotNull CEnvelope aEnvelope) {
        CJsonObject jo = new CJsonObject(true);
        CJsonEnvelopeUtil.addressesToJson(aEnvelope, jo);
        return jo;
    }

    public static void addressesToJson(@NotNull CEnvelope aEnvelope, @NotNull CJsonObject aJsonObject) {
        CRoutingHint routingHint;
        String packetBuilderSequence = aEnvelope.getPacketBuilderSequence();
        if (CUtilString.isValid(packetBuilderSequence)) {
            aJsonObject.put(KEY_PACKET_BUILDER_SEQUENCE, packetBuilderSequence);
        }
        CTargetAddress sender = aEnvelope.getSender();
        aJsonObject.put(KEY_SENDER, sender.valueToString());
        CTargetAddress receiver = aEnvelope.getReceiver();
        aJsonObject.put(KEY_RECEIVER, receiver.valueToString());
        EPriority priority = aEnvelope.getPriority();
        if (priority != EPriority.NORMAL) {
            aJsonObject.put(KEY_PRIORITY, priority.name());
        }
        if (aEnvelope.isNanoServiceMessage()) {
            aJsonObject.put(KEY_IS_NANO_SERVICE_MESSAGE, true);
        }
        if ((routingHint = aEnvelope.getRoutingHint()) != null) {
            CJsonObject or = new CJsonObject(true);
            or.put(KEY_ROUTING_HINT_CLIENT_ADDRESS, routingHint.getAddressOfUnknownNode().valueToString());
            or.put(KEY_ROUTING_HINT_BRIDGE_NODE_ID, routingHint.getIdOfBridgeNode().valueToString());
            aJsonObject.put(KEY_ROUTING_HINT, or);
        }
    }

    public static void fromJsonAddresses(@NotNull CJsonObject aJsonObject, @NotNull CEnvelope aEnvelope) {
        Object o;
        aEnvelope.setPacketBuilderSequence(CUtilJsonString.fromJson(aJsonObject, KEY_PACKET_BUILDER_SEQUENCE, null));
        aEnvelope.setSender(CTargetAddress.fromString(CUtilJsonString.fromJson(aJsonObject, KEY_SENDER, "")));
        aEnvelope.setReceiver(CTargetAddress.fromString(CUtilJsonString.fromJson(aJsonObject, KEY_RECEIVER, "")));
        aEnvelope.setPriority(CUtilEnum.fromString(EPriority.class, CUtilJsonString.fromJson(aJsonObject, KEY_PRIORITY, null), EPriority.NORMAL));
        boolean isServiceMessage = CUtilJsonBoolean.fromJson(aJsonObject, KEY_IS_NANO_SERVICE_MESSAGE, false);
        if (isServiceMessage) {
            aEnvelope.setIsNanoServiceMessage(true);
        }
        if ((o = aJsonObject.getValue(KEY_ROUTING_HINT)) instanceof CJsonObject) {
            CJsonObject jo2 = (CJsonObject)o;
            String s = CUtilJsonString.fromJson(jo2, KEY_ROUTING_HINT_CLIENT_ADDRESS, "");
            CNodeAddress client = CNodeAddress.fromString(s);
            s = CUtilJsonString.fromJson(jo2, KEY_ROUTING_HINT_BRIDGE_NODE_ID, "");
            CNodeId bridge = CNodeId.fromObject(s);
            if (client.isValid() && bridge.isValid()) {
                CRoutingHint routingHint = new CRoutingHint(client, bridge);
                aEnvelope.setRoutingHint(routingHint);
            }
        }
    }

    @NotNull
    public static CJsonObject otherToJson(@NotNull CEnvelope aEnvelope) {
        CJsonObject jo = new CJsonObject(true);
        CJsonEnvelopeUtil.otherToJson(aEnvelope, jo);
        return jo;
    }

    public static void otherToJson(@NotNull CEnvelope aEnvelope, @NotNull CJsonObject aJsonObject) {
        String resultText;
        int resultCode;
        aJsonObject.put(KEY_VERSION, aEnvelope.getVersion());
        UUID transactionId = aEnvelope.getTransactionId();
        if (transactionId != null) {
            aJsonObject.put(KEY_TRANSACTION_ID, CUtilUuid.toString(transactionId));
        }
        if ((resultCode = aEnvelope.getResultCode()) != 0) {
            aJsonObject.put(KEY_RESULT_CODE, resultCode);
        }
        if (CUtilString.isValid(resultText = aEnvelope.getResultText())) {
            aJsonObject.put(KEY_RESULT_TEXT, resultText);
        }
        if (aEnvelope.isAnswer()) {
            aJsonObject.put(KEY_IS_ANSWER, true);
        }
        if (aEnvelope.wantAnswer()) {
            aJsonObject.put(KEY_WANT_ANSWER, true);
        }
    }

    public static void fromJsonOther(@NotNull CJsonObject aRoot, @NotNull CEnvelope aEnvelope) {
        aEnvelope.setVersion((byte)CUtilJsonInteger.fromJson(aRoot, KEY_VERSION, 0));
        aEnvelope.setTransactionId(CUtilUuid.fromString(CUtilJsonString.fromJson(aRoot, KEY_TRANSACTION_ID, null)));
        int resultCode = CUtilJsonInteger.fromJson(aRoot, KEY_RESULT_CODE, 0);
        String resultText = CUtilJsonString.fromJson(aRoot, KEY_RESULT_TEXT, "");
        aEnvelope.setResult(resultCode, resultText);
        aEnvelope.setIsAnswer(CUtilJsonBoolean.fromJson(aRoot, KEY_IS_ANSWER, false));
        aEnvelope.setWantAnswer(CUtilJsonBoolean.fromJson(aRoot, KEY_WANT_ANSWER, false));
    }

    @NotNull
    public static CJsonObject debugToJson(@NotNull CEnvelope aEnvelope) {
        CJsonObject jo = new CJsonObject(true);
        CJsonEnvelopeUtil.debugToJson(aEnvelope, jo);
        return jo;
    }

    public static void debugToJson(@NotNull CEnvelope aEnvelope, @NotNull CJsonObject aJsonObject) {
        Instant timeSendBack;
        Instant timeDeliverAnswer;
        Instant timeSend;
        Instant timeDeliver;
        aJsonObject.put(KEY_INSTANCE, aEnvelope.getInstanceId() % 1000000000);
        if (aEnvelope.isLogEnabled()) {
            aJsonObject.put(KEY_LOG_ENABLED, true);
        }
        if ((timeDeliver = aEnvelope.getTimeDeliver()) != null) {
            aJsonObject.put(KEY_TIME_DELIVER, CUtilInstant.valueToIsoString(timeDeliver));
        }
        if ((timeSend = aEnvelope.getTimeSend()) != null) {
            aJsonObject.put(KEY_TIME_SEND, CUtilInstant.valueToIsoString(timeSend));
        }
        if ((timeDeliverAnswer = aEnvelope.getTimeDeliverAnswer()) != null) {
            aJsonObject.put(KEY_TIME_DELIVER_ANSWER, CUtilInstant.valueToIsoString(timeDeliverAnswer));
        }
        if ((timeSendBack = aEnvelope.getTimeSendBack()) != null) {
            aJsonObject.put(KEY_TIME_SEND_BACK, CUtilInstant.valueToIsoString(timeSendBack));
        }
    }

    public static void fromJsonDebug(@NotNull CJsonObject aRoot, @NotNull CEnvelope aEnvelope) {
        Object o;
        aEnvelope.setInstanceId(CUtilJsonInteger.fromJson(aRoot, KEY_INSTANCE, 0) + 1000000000);
        boolean logEnabled = CUtilJsonBoolean.fromJson(aRoot, KEY_LOG_ENABLED, false);
        if (!logEnabled) {
            aEnvelope.setLogEnabled(false);
        }
        if ((o = aRoot.getValue(KEY_TIME_DELIVER)) instanceof String) {
            aEnvelope.setTimeDeliver(CUtilInstant.fromIsoString((String)o));
        }
        if ((o = aRoot.getValue(KEY_TIME_SEND)) instanceof String) {
            aEnvelope.setTimeSend(CUtilInstant.fromIsoString((String)o));
        }
        if ((o = aRoot.getValue(KEY_TIME_DELIVER_ANSWER)) instanceof String) {
            aEnvelope.setTimeDeliverAnswer(CUtilInstant.fromIsoString((String)o));
        }
        if ((o = aRoot.getValue(KEY_TIME_SEND_BACK)) instanceof String) {
            aEnvelope.setTimeSendBack(CUtilInstant.fromIsoString((String)o));
        }
    }
}

