/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CEnvelopeHeaderFactory;
import de.sillysky.nyssr.message.CEnvelopePrinter;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.message.CStreamHeaderBasicEnvelope;
import de.sillysky.nyssr.message.CStreamHeaderDebug;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderFactoryRegistry;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CEnvelope {
    public static final int BILLION = 1000000000;
    private static final AtomicBoolean DEBUG = new AtomicBoolean(false);
    private static final AtomicReference<CStreamHeaderFactoryRegistry<CEnvelope>> HEADER_FACTORY = new AtomicReference<Object>(null);
    private static final byte KNOWN_VERSION_0 = 0;
    private static final AtomicInteger NEXT_INSTANCE_ID = new AtomicInteger();
    private static final AtomicInteger NEXT_TRANSPORTED_ID = new AtomicInteger();
    private static byte mVersion = 0;
    private int mInstanceId = NEXT_INSTANCE_ID.incrementAndGet();
    @NotNull
    private final Stack<CTargetAddress> mReceiver = new Stack();
    @NotNull
    private CTargetAddress mSender = CTargetAddress.getInvalidAddress();
    private boolean mIsAnswer = false;
    private boolean mWantAnswer = false;
    private boolean mIsOnlyLocal = false;
    private boolean mIsLogEnabled = true;
    private boolean mHasBeenHandled = false;
    private boolean mIsNanoServiceMessage = false;
    private boolean mForwardMessage = false;
    private boolean mIsBlocked = false;
    private int mResultCode = 2001;
    @NotNull
    private String mResultText = "";
    @Nullable
    private UUID mTransactionId = null;
    @NotNull
    private EPriority mPriority = EPriority.NORMAL;
    private Instant mTimeSend = null;
    private Instant mTimeDeliver = null;
    private Instant mTimeSendBack = null;
    private Instant mTimeDeliverAnswer = null;
    private short mEnvId = (short)NEXT_TRANSPORTED_ID.incrementAndGet();
    private String mPacketBuilderSequence = null;
    @Nullable
    private CRoutingHint mRoutingHint = null;
    @Nullable
    private IId mMicroServiceId = null;

    @NotNull
    public static CEnvelope forMicroService(@NotNull IId aMicroServiceId) {
        CEnvelope env = new CEnvelope();
        env.setMicroServiceId(aMicroServiceId);
        return env;
    }

    @NotNull
    public static CEnvelope forLocalNanoService(@NotNull IId aNID) {
        CTargetAddress receiver = new CTargetAddress(IId.INVALID, aNID);
        CEnvelope env = new CEnvelope();
        env.setReceiver(receiver);
        return env;
    }

    @NotNull
    public static CEnvelope forLocalNanoService(@NotNull Class<? extends IGeneratedRecord> aClass) throws CException {
        try {
            Field f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            IId nid = CIdFactory.fromObject(namespaces[0]);
            return CEnvelope.forLocalNanoService(nid);
        }
        catch (Exception e) {
            throw new CException(29).append(e.getMessage());
        }
    }

    @NotNull
    public static CEnvelope forRemoteNanoService(@NotNull IId aNID, @NotNull CNodeId aNodeId) {
        CEnvelope env = new CEnvelope();
        CTargetAddress receiver = new CTargetAddress(IId.INVALID, aNID, aNodeId);
        env.setReceiver(receiver);
        return env;
    }

    @NotNull
    public static CEnvelope forRemoteNanoService(@NotNull IId aNID, @NotNull CNodeAddress aNodeAddress) {
        CEnvelope env = new CEnvelope();
        CTargetAddress receiver = new CTargetAddress(IId.INVALID, aNID, aNodeAddress.getNodeId(), aNodeAddress.getSegmentId());
        env.setReceiver(receiver);
        return env;
    }

    @NotNull
    public static CEnvelope forRemoteNanoService(@NotNull Class<? extends IGeneratedRecord> aClass, @NotNull CNodeAddress aNodeAddress) throws CException {
        try {
            Field f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            IId nid = CIdFactory.fromObject(namespaces[0]);
            CTargetAddress receiver = new CTargetAddress(IId.INVALID, nid, aNodeAddress.getNodeId(), aNodeAddress.getSegmentId());
            CEnvelope env = new CEnvelope();
            env.setReceiver(receiver);
            return env;
        }
        catch (Exception e) {
            throw new CException(29).append(e.getMessage());
        }
    }

    @NotNull
    public static CEnvelope forSingleTarget(@Nullable IId aTID, @Nullable IId aNID, @Nullable CNodeId aNodeId) {
        CTargetAddress receiver = new CTargetAddress(aTID == null ? IId.INVALID : aTID, aNID == null ? IId.INVALID : aNID, aNodeId == null ? CNodeId.getEmpty() : aNodeId);
        CEnvelope env = new CEnvelope();
        env.setReceiver(receiver);
        return env;
    }

    @NotNull
    public static CEnvelope forSingleTarget(@Nullable IId aTID, @Nullable IId aNID, @Nullable CNodeAddress aNodeAddress) {
        CTargetAddress receiver = new CTargetAddress(aTID == null ? IId.INVALID : aTID, aNID == null ? IId.INVALID : aNID, aNodeAddress == null ? CNodeId.EMPTY : aNodeAddress.getNodeId(), aNodeAddress == null ? CSegmentId.EMPTY : aNodeAddress.getSegmentId());
        CEnvelope env = new CEnvelope();
        env.setReceiver(receiver);
        return env;
    }

    @NotNull
    public static CEnvelope forSingleTarget(CTargetAddress aReceiver) {
        CEnvelope env = new CEnvelope();
        env.setReceiver(aReceiver);
        return env;
    }

    @NotNull
    public static CEnvelope copy(@NotNull CEnvelope aEnvelope) {
        CEnvelope env = new CEnvelope();
        env.setHandled(aEnvelope.hasBeenHandled());
        env.setIsAnswer(aEnvelope.isAnswer());
        env.setBlocked(aEnvelope.isBlocked());
        env.setLogEnabled(aEnvelope.isLogEnabled());
        env.setOnlyLocal(aEnvelope.isOnlyLocal());
        env.setPriority(aEnvelope.getPriority());
        env.getReceivers().addAll(aEnvelope.mReceiver);
        env.setResult(aEnvelope.getResultCode(), aEnvelope.getResultText());
        env.setSender(aEnvelope.getSender());
        env.setTimeDeliver(aEnvelope.getTimeDeliver());
        env.setTimeDeliverAnswer(aEnvelope.getTimeDeliverAnswer());
        env.setTimeSend(aEnvelope.getTimeSend());
        env.setTimeSendBack(aEnvelope.getTimeSendBack());
        env.setTransactionId(aEnvelope.getTransactionId());
        env.setWantAnswer(aEnvelope.wantAnswer());
        env.setIsNanoServiceMessage(aEnvelope.isNanoServiceMessage());
        env.setPacketBuilderSequence(aEnvelope.getPacketBuilderSequence());
        env.setEnvId(aEnvelope.getEnvId());
        env.setForwardMessage(aEnvelope.mForwardMessage);
        env.setRoutingHint(aEnvelope.mRoutingHint);
        env.setMicroServiceId(aEnvelope.getMicroServiceId());
        return env;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CEnvelope fromStream(@NotNull DataInput aStream) throws IOException {
        CEnvelope env = new CEnvelope();
        CStreamHeaderList<CEnvelope> list = new CStreamHeaderList<CEnvelope>();
        list.unpack(aStream, env, HEADER_FACTORY.get());
        return env;
    }

    public static boolean isDebug() {
        return DEBUG.get();
    }

    public static void setDebug(boolean aDebug) {
        DEBUG.set(aDebug);
    }

    public CResult canSwap() {
        CResult error = null;
        if (this.mIsAnswer) {
            error = new CResult(2002, "Cannot swap, Message is Answer");
        } else if (!this.mSender.getTID().isValid()) {
            error = new CResult(2008, "Cannot swap, sender TID is null");
        }
        return error;
    }

    private void clear() {
        this.setBlocked(false);
        this.setIsAnswer(false);
        this.mReceiver.clear();
        this.mSender = CTargetAddress.getInvalidAddress();
        this.setResult(null);
        this.mTimeSend = null;
        this.mTimeDeliver = null;
        this.mTimeSendBack = null;
        this.mTimeDeliverAnswer = null;
    }

    public void setLogEnabled(boolean aEnabled) {
        this.mIsLogEnabled = aEnabled;
    }

    public void forwardMessage(CTargetAddress aReceiver) {
        this.setResultSuccess();
        if (aReceiver != null) {
            this.mForwardMessage = true;
            if (!this.mReceiver.empty()) {
                this.mReceiver.pop();
            }
            this.mReceiver.push(aReceiver);
        } else {
            this.mForwardMessage = false;
        }
    }

    private void setForwardMessage(boolean aForwardMessage) {
        this.mForwardMessage = aForwardMessage;
    }

    public CEnvelope getCopy() {
        return CEnvelope.copy(this);
    }

    public short getEnvId() {
        return this.mEnvId;
    }

    void setEnvId(short aEnvId) {
        this.mEnvId = aEnvId;
    }

    public int getInstanceId() {
        return this.mInstanceId;
    }

    public void setInstanceId(int aInstanceId) {
        this.mInstanceId = aInstanceId;
    }

    public String getPacketBuilderSequence() {
        return this.mPacketBuilderSequence;
    }

    public void setPacketBuilderSequence(String aSequence) {
        this.mPacketBuilderSequence = aSequence;
    }

    @NotNull
    public EPriority getPriority() {
        return this.mPriority;
    }

    public void setPriority(@NotNull EPriority aPriority) {
        this.mPriority = aPriority;
    }

    @NotNull
    public CTargetAddress getReceiver() {
        return this.mReceiver.empty() ? CTargetAddress.getInvalidAddress() : this.mReceiver.peek();
    }

    public void setReceiver(@Nullable CTargetAddress aReceiver) {
        if (!this.mReceiver.empty()) {
            this.mReceiver.pop();
        }
        if (aReceiver != null) {
            this.mReceiver.push(aReceiver);
        }
    }

    @NotNull
    public Stack<CTargetAddress> getReceivers() {
        return this.mReceiver;
    }

    @NotNull
    public CResult getResult() {
        return new CResult(this.mResultCode, this.mResultText);
    }

    public void setResult(CResult aResult) {
        if (aResult == null) {
            this.setResultSuccess();
        } else {
            this.mResultCode = aResult.getCode();
            this.mResultText = aResult.getText();
        }
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @NotNull
    public String getResultText() {
        return this.mResultText;
    }

    @NotNull
    public CTargetAddress getSender() {
        return this.mSender;
    }

    public void setSender(CTargetAddress aSender) {
        this.mSender = aSender == null ? CTargetAddress.getInvalidAddress() : aSender;
    }

    @Nullable
    public Instant getTimeDeliver() {
        return this.mTimeDeliver;
    }

    public void setTimeDeliver(@Nullable Instant aTimeDeliver) {
        this.mTimeDeliver = aTimeDeliver;
    }

    @Nullable
    public Instant getTimeDeliverAnswer() {
        return this.mTimeDeliverAnswer;
    }

    public void setTimeDeliverAnswer(@Nullable Instant aTimeDeliverAnswer) {
        this.mTimeDeliverAnswer = aTimeDeliverAnswer;
    }

    @Nullable
    public Instant getTimeSend() {
        return this.mTimeSend;
    }

    public void setTimeSend(@Nullable Instant aTimeSend) {
        this.mTimeSend = aTimeSend;
    }

    @Nullable
    public Instant getTimeSendBack() {
        return this.mTimeSendBack;
    }

    public void setTimeSendBack(@Nullable Instant aTimeSendBack) {
        this.mTimeSendBack = aTimeSendBack;
    }

    @Nullable
    public UUID getTransactionId() {
        return this.mTransactionId;
    }

    public void setTransactionId(@Nullable UUID aId) {
        this.mTransactionId = aId;
    }

    public byte getVersion() {
        return mVersion;
    }

    public void setVersion(byte aVersion) {
        mVersion = aVersion;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CEnvelope cEnvelope = (CEnvelope)aO;
        return this.mIsAnswer == cEnvelope.mIsAnswer && this.mWantAnswer == cEnvelope.mWantAnswer && this.mResultCode == cEnvelope.mResultCode && this.mIsOnlyLocal == cEnvelope.mIsOnlyLocal && this.mIsLogEnabled == cEnvelope.mIsLogEnabled && this.mHasBeenHandled == cEnvelope.mHasBeenHandled && this.mIsNanoServiceMessage == cEnvelope.mIsNanoServiceMessage && this.mForwardMessage == cEnvelope.mForwardMessage && this.mIsBlocked == cEnvelope.mIsBlocked && this.mTimeSend == cEnvelope.mTimeSend && this.mTimeDeliver == cEnvelope.mTimeDeliver && this.mTimeSendBack == cEnvelope.mTimeSendBack && this.mTimeDeliverAnswer == cEnvelope.mTimeDeliverAnswer && this.mReceiver.equals(cEnvelope.mReceiver) && this.mSender.equals(cEnvelope.mSender) && Objects.equals(this.mResultText, cEnvelope.mResultText) && Objects.equals(this.mTransactionId, cEnvelope.mTransactionId) && this.mPriority == cEnvelope.mPriority && Objects.equals(this.mPacketBuilderSequence, cEnvelope.mPacketBuilderSequence);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mReceiver, this.mSender, this.mIsAnswer, this.mWantAnswer, this.mResultCode, this.mResultText, this.mIsOnlyLocal, this.mIsLogEnabled, this.mHasBeenHandled, this.mIsNanoServiceMessage, this.mForwardMessage, this.mTransactionId, this.mPriority, this.mIsBlocked, this.mTimeSend, this.mTimeDeliver, this.mTimeSendBack, this.mTimeDeliverAnswer, this.mPacketBuilderSequence});
    }

    public boolean hasBeenHandled() {
        return this.mHasBeenHandled;
    }

    public boolean isAnswer() {
        return this.mIsAnswer;
    }

    public boolean isBlocked() {
        return this.mIsBlocked;
    }

    public void setBlocked(boolean aBlocked) {
        this.mIsBlocked = aBlocked;
    }

    public boolean isLogEnabled() {
        return this.mIsLogEnabled;
    }

    public boolean isNanoServiceMessage() {
        return this.mIsNanoServiceMessage;
    }

    public boolean isOnlyLocal() {
        return this.mIsOnlyLocal;
    }

    public boolean isRawTransport() {
        return "M".equals(this.mPacketBuilderSequence);
    }

    public void setHandled(boolean aHandled) {
        this.mHasBeenHandled = aHandled;
        if (aHandled) {
            if (this.mResultCode == 2001) {
                this.mResultCode = 0;
                this.mResultText = "";
            }
        } else if (this.mResultCode == 0) {
            this.mResultCode = 2001;
        }
    }

    public void setIsAnswer(boolean aIsAnswer) {
        this.mIsAnswer = aIsAnswer;
    }

    public void setIsNanoServiceMessage(boolean aIsNanoMessage) {
        this.mIsNanoServiceMessage = aIsNanoMessage;
    }

    public void setOnlyLocal(boolean aOnlyLocal) {
        this.mIsOnlyLocal = aOnlyLocal;
    }

    public void setRawTransport() {
        this.mPacketBuilderSequence = "M";
    }

    public void setResult(int aCode, String aText) {
        this.mResultCode = aCode;
        this.mResultText = aText == null ? "" : aText;
    }

    public void setResultSuccess() {
        this.mResultCode = 0;
        this.mResultText = "";
    }

    public void setWantAnswer(boolean aWantAnswer) {
        this.mWantAnswer = aWantAnswer;
    }

    public boolean shallForward() {
        return this.mForwardMessage;
    }

    public CResult swap() {
        CResult error = this.canSwap();
        if (error == null) {
            CTargetAddress temp = this.getReceiver();
            this.mReceiver.clear();
            this.setReceiver(this.mSender);
            this.mSender = temp;
            this.mWantAnswer = false;
            this.mIsAnswer = true;
        }
        return error;
    }

    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CStreamHeaderList list = new CStreamHeaderList();
        list.add(new CStreamHeaderBasicEnvelope(this));
        if (DEBUG.get()) {
            list.add(new CStreamHeaderDebug(this));
        }
        byte[] packedEnvelope = list.pack();
        aStream.write(packedEnvelope);
    }

    public String toString() {
        return new CEnvelopePrinter(this).print();
    }

    public boolean wantAnswer() {
        return this.mWantAnswer;
    }

    public void ensureCompleteAddresses() {
        CTargetAddress receiver;
        CTargetAddress sender = this.getSender().getCompletedAddress();
        if (sender != null) {
            this.setSender(sender);
        }
        if ((receiver = this.getReceiver().getCompletedAddress()) != null) {
            this.setReceiver(receiver);
        }
    }

    @Nullable
    public CRoutingHint getRoutingHint() {
        return this.mRoutingHint;
    }

    public void setRoutingHint(@Nullable CRoutingHint aRoutingHint) {
        this.mRoutingHint = aRoutingHint;
    }

    @Nullable
    public IId getMicroServiceId() {
        return this.mMicroServiceId;
    }

    public void setMicroServiceId(@Nullable IId aMicroServiceId) {
        this.mMicroServiceId = aMicroServiceId;
    }

    static {
        CStreamHeaderFactoryRegistry<CEnvelope> reg = new CStreamHeaderFactoryRegistry<CEnvelope>();
        CEnvelopeHeaderFactory factory = new CEnvelopeHeaderFactory();
        reg.registerFactory(1, factory);
        reg.registerFactory(2, factory);
        HEADER_FACTORY.set(reg);
    }
}

