/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message;

import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.files.CResourceHandler;
import de.sillysky.nyssr.util.streamheader.CBasicStreamHeader;
import de.sillysky.nyssr.util.time.CUtilInstant;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.time.Instant;

final class CStreamHeaderDebug
extends CBasicStreamHeader<CEnvelope> {
    CStreamHeaderDebug(CEnvelope aOwner) {
        super(2, aOwner, null);
    }

    CStreamHeaderDebug(CEnvelope aOwner, byte[] aBytes) {
        super(2, aOwner, aBytes);
    }

    @Override
    public void pack() {
        if (this.getPackedData() != null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            @Override
            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream bStream = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bStream);
                this.registerResource(dos);
                CEnvelope env = (CEnvelope)CStreamHeaderDebug.this.getOwner();
                short envId = env.getEnvId();
                dos.writeShort(envId);
                Instant timeSend = env.getTimeSend();
                CUtilInstant.toStream(dos, timeSend);
                Instant timeSendBack = env.getTimeSendBack();
                CUtilInstant.toStream(dos, timeSendBack);
                Instant timeDeliver = env.getTimeDeliver();
                CUtilInstant.toStream(dos, timeDeliver);
                Instant timeDeliverAnswer = env.getTimeDeliverAnswer();
                CUtilInstant.toStream(dos, timeDeliverAnswer);
                dos.close();
                return bStream.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        byte[] result = (byte[])handler.getResult();
        this.setPackedHeaderBytes(result);
    }

    @Override
    public void unpack() {
        final byte[] packedData = this.getPackedData();
        if (packedData == null) {
            return;
        }
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            @Override
            protected byte[] doResourceHandling() throws Exception {
                ByteArrayInputStream bStream = new ByteArrayInputStream(packedData);
                DataInputStream dis = new DataInputStream(bStream);
                this.registerResource(dis);
                CEnvelope env = (CEnvelope)CStreamHeaderDebug.this.getOwner();
                short envId = dis.readShort();
                env.setEnvId(envId);
                Instant timeSend = CUtilInstant.fromStream(dis);
                env.setTimeSend(timeSend);
                Instant timeSendBack = CUtilInstant.fromStream(dis);
                env.setTimeSendBack(timeSendBack);
                Instant timeDeliver = CUtilInstant.fromStream(dis);
                env.setTimeDeliver(timeDeliver);
                Instant timeDeliverAnswer = CUtilInstant.fromStream(dis);
                env.setTimeDeliverAnswer(timeDeliverAnswer);
                return null;
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
    }
}

