/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.notification.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyAnnounceReboot
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("df1dc210-01dd-4323-95c5-ae00e751a8be");
    public static final String NAME = "NotifyAnnounceReboot";
    public static final String DESCRIPTION = "Notification that a reboot has been announced";
    public static final String SLOT_TIME = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static Instant getTime(@NotNull CRecord aRecord, Instant aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME);
        if (slot == null) {
            return aDefault;
        }
        return (Instant)slot.getValue();
    }

    public static void setTime(@NotNull CRecord aRecord, Instant aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INSTANT, aValue);
        aRecord.addSlot(SLOT_TIME, slot);
    }
}

