/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.notification.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyRemoteNodeAdded
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("be125fa3-b4a7-493c-ad9a-5fa1a23be84d");
    public static final String NAME = "NotifyRemoteNodeAdded";
    public static final String DESCRIPTION = "Notification that a remote node has been added. It is now possible to send messages to the remote node.";
    public static final String SLOT_REMOTE_NODE = "1";
    public static final String SLOT_TYPE = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CNodeAddress getRemoteNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static String getType(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setRemoteNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.NODE_ADDRESS, aValue);
        aRecord.addSlot(SLOT_REMOTE_NODE, slot);
    }

    public static void setType(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_TYPE, slot);
    }
}

