/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.target.monitor.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordTargetMonitorNotifyTargetRegistered
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("45950e8f-b034-4ac0-91ff-793eb4a4e193");
    public static final String NAME = "TargetMonitorNotifyTargetRegistered";
    public static final String DESCRIPTION = "Target Monitor: Monitored target registered.";
    public static final String SLOT_ADDRESS = "1";
    public static final String SLOT_CLASS_NAME = "3";
    public static final String SLOT_NAME = "2";
    public static final String SLOT_QUEUE_ID = "5";
    public static final String SLOT_SIMPLE_CLASS_NAME = "4";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static String getClassName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CLASS_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getQueueId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_QUEUE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static String getSimpleClassName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SIMPLE_CLASS_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_ADDRESS, slot);
    }

    public static void setClassName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_CLASS_NAME, slot);
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setQueueId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_QUEUE_ID, slot);
    }

    public static void setSimpleClassName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_SIMPLE_CLASS_NAME, slot);
    }
}

