/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilChar;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilCharArray {
    public static final char[] EMPTY = new char[0];
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilCharArray.class);

    private CUtilCharArray() {
    }

    public static char[] copy(char[] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static char[] fromList(List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Character> list = new ArrayList<Character>();
        for (Object element : aValue) {
            char[] cc;
            Object[] cc2;
            if (element == null) continue;
            if (element instanceof Character) {
                Character c = (Character)element;
                list.add(c);
                continue;
            }
            if (element instanceof char[]) {
                for (char c : cc2 = (char[])element) {
                    list.add(Character.valueOf(c));
                }
                continue;
            }
            if (element instanceof Character[]) {
                cc2 = (Character[])element;
                list.addAll(Arrays.asList(cc2));
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            for (char c : cc = CUtilCharArray.fromString(s)) {
                list.add(Character.valueOf(c));
            }
        }
        char[] arr = new char[list.size()];
        int pos = 0;
        for (Character element : list) {
            arr[pos] = element.charValue();
            ++pos;
        }
        return arr;
    }

    public static char @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        char[] array = new char[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = aStream.readChar();
        }
        return array;
    }

    public static char @NotNull [] fromString(String aValue) {
        return CUtilCharArray.fromString(aValue, ",");
    }

    public static char @NotNull [] fromString(String aValue, String aDelimiter) {
        char[] arr;
        if (aValue == null || aValue.isEmpty()) {
            arr = new char[]{};
        } else {
            String[] tokens = aValue.split(aDelimiter, -1);
            arr = new char[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = CUtilChar.fromString(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(char[] aValue1, char[] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toString(char @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : Character.toString(aValue[index]));
    }

    @NotNull
    public static String toString(char @Nullable [] aValue, int aStartIndex, int aEndIndex, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(aStartIndex, aDelimiter, aMaxLen, index -> index >= aEndIndex ? "\uf00bE" : Character.toString(aValue[index]));
    }

    public static void toList(char[] aValue, int aMaxPerRow, @NotNull List<String> aList) {
        int len;
        if (aValue == null || aValue.length == 0) {
            return;
        }
        if (aMaxPerRow <= 0) {
            LOG.error("valueToList: invalid argument aMaxPerRow: {}", aMaxPerRow);
            return;
        }
        for (int pos = 0; pos < aValue.length; pos += len) {
            len = aMaxPerRow;
            if (pos + len > aValue.length) {
                len = aValue.length - pos;
            }
            if (len <= 0) break;
            String s = CUtilCharArray.toString(aValue, pos, len, ',', 0);
            aList.add(s);
        }
    }

    public static void toStream(@NotNull DataOutput aStream, char[] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (char element : aValue) {
                aStream.writeChar(element);
            }
        }
    }

    @Nullable
    public static Object toJson(char[] aChars) {
        if (aChars != null && aChars.length > 0) {
            return new String(aChars);
        }
        return null;
    }

    public static char[] fromJson(@Nullable Object aValue) {
        if (aValue instanceof String) {
            String s = (String)aValue;
            return s.toCharArray();
        }
        return null;
    }

    public static char @NotNull [] random(int aSize) {
        char[] arr = new char[aSize];
        for (int i = 0; i < aSize; ++i) {
            arr[i] = CUtilChar.random();
        }
        return arr;
    }
}

