/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilDouble {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilDouble.class);

    private CUtilDouble() {
    }

    public static double fromObject(@Nullable Object aValue, double aDefault) {
        double result = aDefault;
        if (aValue != null) {
            if (aValue instanceof Double) {
                result = (Double)aValue;
            } else if (aValue instanceof Float) {
                result = ((Float)aValue).floatValue();
            } else if (aValue instanceof Short) {
                result = ((Short)aValue).shortValue();
            } else if (aValue instanceof Integer) {
                result = ((Integer)aValue).intValue();
            } else if (aValue instanceof Long) {
                result = ((Long)aValue).longValue();
            } else if (aValue instanceof Byte) {
                result = ((Byte)aValue).byteValue();
            } else if (aValue instanceof Character) {
                result = ((Character)aValue).charValue();
            } else if (aValue instanceof String) {
                result = CUtilDouble.fromString((String)aValue);
            } else {
                LOG.error("Can't convert object {} to double. Take default value '0.0'", aValue);
            }
        }
        return result;
    }

    public static double fromString(@Nullable String aValue) {
        double result;
        if (aValue == null) {
            result = 0.0;
        } else {
            try {
                result = Double.parseDouble(aValue);
            }
            catch (NumberFormatException e) {
                result = 0.0;
            }
        }
        return result;
    }

    @NotNull
    public static String toString(double aValue) {
        return Double.toString(aValue);
    }

    @NotNull
    public static String toString(double aValue, int aMaxLen) {
        String result = CUtilDouble.toString(aValue);
        result = CUtilString.shortenString(result, aMaxLen);
        return result;
    }

    @NotNull
    public static String toStringRecord(short aType, double aValue) {
        String key = Short.toString(aType);
        String value = CUtilDouble.toString(aValue);
        CStringRecord r = new CStringRecord(key, value);
        return r.getRecordString();
    }

    public static double random() {
        return CUtilRandom.getRandom().nextDouble();
    }
}

