/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.stream;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.CUtilByteArray;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CUtilStream {
    private static final int BUFLEN = 10000;

    private CUtilStream() {
    }

    public static byte[] readByteArrayFully(InputStream aStream, int aLength) throws IOException {
        CUtilCheck.checkNotNull(aStream, "InputStream is null", new Object[0]);
        CUtilCheck.checkTrue(aLength > 0, "Length <= 0", new Object[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(aLength);
        byte[] buf = new byte[Math.min(aLength, 10000)];
        int readSum = 0;
        int read = aStream.read(buf, 0, Math.min(aLength - readSum, 10000));
        while (read > 0 && readSum < aLength) {
            baos.write(buf, 0, read);
            read = aStream.read(buf, 0, Math.min(aLength - (readSum += read), 10000));
        }
        return baos.toByteArray();
    }

    public static byte[] readByteArrayFully(InputStream aStream) throws IOException {
        CUtilCheck.checkNotNull(aStream, "InputStream is null", new Object[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(aStream.available());
        byte[] buf = new byte[10000];
        int read = aStream.read(buf, 0, 10000);
        while (read > 0) {
            baos.write(buf, 0, read);
            read = aStream.read(buf, 0, 10000);
        }
        return baos.toByteArray();
    }

    public static void writeBytes(DataOutput aStream, int aNumber, byte aByte) throws IOException {
        int portion;
        byte[] buf = CUtilByteArray.createFilled(10000, aByte);
        int left = aNumber;
        do {
            portion = Math.min(buf.length, left);
            aStream.write(buf, 0, portion);
        } while ((long)(left -= portion) > 0L);
    }

    public static void writeBytes(OutputStream aStream, byte[] aBytes) throws IOException {
        CUtilCheck.checkNotNull(aStream, "OutputStream missing", new Object[0]);
        CUtilCheck.checkNotNull(aBytes, "ByteArray missing", new Object[0]);
        if (aBytes.length > 0) {
            int portion;
            int left = aBytes.length;
            do {
                portion = Math.min(aBytes.length, left);
                aStream.write(aBytes, aBytes.length - left, portion);
            } while ((long)(left -= portion) > 0L);
        }
    }
}

