/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilZonedDateTime {
    private static final String DELIMITER = ",";

    private CUtilZonedDateTime() {
    }

    public static ZonedDateTime fromString(@NotNull String aValue, @NotNull DateTimeFormatter aFormatter) {
        ZonedDateTime result;
        try {
            result = ZonedDateTime.parse(aValue, aFormatter);
        }
        catch (Exception e) {
            try {
                LocalDateTime temp = LocalDateTime.parse(aValue, aFormatter);
                ZoneId zoneId = ZoneId.systemDefault();
                result = temp.atZone(zoneId);
            }
            catch (Exception aE) {
                LocalDate temp2 = LocalDate.parse(aValue, aFormatter);
                ZoneId zoneId = ZoneId.systemDefault();
                result = temp2.atStartOfDay(zoneId);
            }
        }
        return result;
    }

    @Nullable
    public static ZonedDateTime fromString(@Nullable String aValue, @Nullable ZonedDateTime aDefault) {
        ZonedDateTime result;
        if (CUtilString.isEmpty(aValue)) {
            return aDefault;
        }
        if (aValue.contains(DELIMITER)) {
            String[] arr = aValue.split(DELIMITER);
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(arr[0]);
            result = CUtilZonedDateTime.fromString(arr[1], dtf);
        } else {
            result = ZonedDateTime.parse(aValue);
        }
        return result;
    }

    @NotNull
    public static String toString(@NotNull ZonedDateTime aZonedDateTime) {
        return aZonedDateTime.toString();
    }

    @NotNull
    public static String toIsoString(@NotNull ZonedDateTime aValue) {
        DateTimeFormatter dtf = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        return dtf.format(aValue);
    }

    @NotNull
    public static ZonedDateTime fromIsoString(@NotNull String aValue) {
        DateTimeFormatter dtf = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        TemporalAccessor ta = dtf.parse(aValue);
        return ZonedDateTime.from(ta);
    }

    @Nullable
    public static ZonedDateTime fromStream(@NotNull DataInput aStream) throws IOException {
        boolean b = aStream.readBoolean();
        if (!b) {
            return null;
        }
        long seconds = aStream.readLong();
        int nanos = aStream.readInt();
        Instant dateTime = Instant.ofEpochSecond(seconds, nanos);
        String zoneIdString = aStream.readUTF();
        ZoneId zoneId = ZoneId.of(zoneIdString);
        return ZonedDateTime.ofInstant(dateTime, zoneId);
    }

    public static ZonedDateTime @Nullable [] arrayFromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        ZonedDateTime[] array = new ZonedDateTime[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CUtilZonedDateTime.fromStream(aStream);
        }
        return array;
    }

    public static void arrayToStream(@NotNull DataOutput aStream, @Nullable ZonedDateTime[] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (ZonedDateTime time : aValue) {
                CUtilZonedDateTime.toStream(aStream, time);
            }
        }
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable ZonedDateTime aValue) throws IOException {
        if (aValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            Instant instant = aValue.toInstant();
            aStream.writeLong(instant.getEpochSecond());
            aStream.writeInt(instant.getNano());
            ZoneId zone = aValue.getZone();
            String id = zone.getId();
            aStream.writeUTF(id);
        }
    }

    public static String valueToString(@Nullable ZonedDateTime aValue) {
        return aValue == null ? "" : CUtilZonedDateTime.toIsoString(aValue);
    }
}

