/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.costs;

import de.sillysky.nyssr.address.CNodeId;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

class CCostEntry {
    private final CNodeId mNode;
    private int mCostSum;
    private int mCostCount;
    private ZonedDateTime mTime;

    CCostEntry(@NotNull CNodeId aNode) {
        this.mNode = aNode;
    }

    CNodeId getNode() {
        return this.mNode;
    }

    void addCosts(int aCosts) {
        this.mCostSum += aCosts;
        ++this.mCostCount;
        this.mTime = ZonedDateTime.now();
    }

    void reset() {
        this.mCostSum = 0;
        this.mCostCount = 0;
        this.mTime = ZonedDateTime.now();
    }

    int getAverage() {
        if (this.mCostCount > 0) {
            return this.mCostSum / this.mCostCount;
        }
        return 0;
    }

    int getRecordCount() {
        return this.mCostCount;
    }

    ZonedDateTime getTimeOfMeasurement() {
        return this.mTime;
    }
}

