/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodes;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.nodeinfo.CNodeInfoUtil;
import de.sillysky.nyssr.impl.network.nodes.CKeyHelper;
import de.sillysky.nyssr.impl.network.nodes.CLocalConstants;
import de.sillysky.nyssr.impl.network.nodes.CNodeInfoList;
import de.sillysky.nyssr.impl.network.nodes.IDependencies;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.namedb.IGeneralIdDatabase;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordDataNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordGetNodeInfo;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyNodeInfoArrived;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetNodeRecord;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyNodeRecordUpdated;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CNodeInfoDatabase
extends CTarget
implements INodeInfoDatabase,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNodeInfoDatabase.class);
    private static final ILogger LOG_AES = CLoggerFactory.getLogger((String)"network.aes");
    private static final ILogger LOG_NODE = CLoggerFactory.getLogger((String)"network.node");
    private static final ILogger LOG_LOST = CLoggerFactory.getLogger((String)"network.lost");
    private final CNodeInfoList mNodeInfoList = new CNodeInfoList();
    private final IDependencies mDependencies;
    private final List<CMessage> mPendingAnswers = new ArrayList<CMessage>();
    private String mMyPacketBuilderSequence;
    private CNodeInfoDto mLocalNodeInfo;

    public CNodeInfoDatabase(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
        this.mMyPacketBuilderSequence = preferences.get("packet.builder.sequence", "M");
        this.addLocalNodeToList();
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordGetNodeInfo.ID, this::asyncGetNodeInfo);
        this.addMessageHandler(CRecordNetworkGetNodeRecord.ID, this::asyncGetNodeRecord);
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CLocalConstants.NID, "TRANSPORT");
        ns.getTargetRegistry().registerTarget((ITarget)this, CLocalConstants.TID);
        aServiceRegistry.registerService(INodeInfoDatabase.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(this.getAddress(), "NodeInfoDatabase");
        IGeneralIdDatabase idDatabase = this.mDependencies.getNameDb().getGeneralIdDatabase();
        idDatabase.putName(CRecordDataNodeInfo.ID, "DataNodeInfo");
        idDatabase.putName(CRecordGetNodeInfo.ID, "GetNodeInfo");
        INamespace nsSystem = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        assert (nsSystem != null);
        nsSystem.getNanoServiceRegistry().addNanoServiceAndObserver(CRecordGetNodeInfo.class, this.getAddress(), false);
        return true;
    }

    private boolean asyncGetNodeInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordGetNodeInfo.getNode((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node, (String)"Missing NodeAddress", (Object[])new Object[0]);
        CNodeInfoDto info = this.mNodeInfoList.get(node);
        if (info != null) {
            CRecord record = CNodeInfoUtil.createRecord(info);
            CRecordGetNodeInfo.setNodeInfo((CRecord)aRecord, (CRecord)record);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(5302, "Unknown Node");
        }
        return true;
    }

    private boolean asyncGetNodeRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CNodeAddress remoteAddress = aEnvelope.getSender().getNodeAddress();
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                CRecord nodeInfoRecord = CRecordNetworkGetNodeRecord.getNodeInfo((CRecord)aRecord, null);
                CNodeInfoDto updatedRemoteInfo = CNodeInfoDto.fromRecord((CRecord)nodeInfoRecord);
                if (updatedRemoteInfo != null) {
                    this.updateNodeInfo(updatedRemoteInfo);
                    CNodeInfoDto remoteInfo = this.getOrCreateNodeRecord(remoteAddress);
                    byte[] encryptedSessionKey = CRecordNetworkGetNodeRecord.getSessionKey((CRecord)aRecord, null);
                    if (encryptedSessionKey != null) {
                        KeyPair rsaKey = CKeyHelper.getOrCreateMyRsaKey();
                        SecretKey sessionKey = CKeyHelper.decryptSessionKey(encryptedSessionKey, rsaKey.getPrivate());
                        remoteInfo.setHisSessionKey(sessionKey);
                    } else {
                        remoteInfo.setHisSessionKey(null);
                    }
                    SecretKey his = remoteInfo.getHisSessionKey();
                    SecretKey mine = CNodeInfoUtil.getMySessionKey(remoteInfo);
                    LOG_AES.debug("AES: Got Session Key from {}, his = {}, my = {}", new Object[]{remoteInfo.getNodeAddress(), his.hashCode(), mine.hashCode()});
                    remoteInfo.setValidated();
                    List<CMessage> messages = CNodeInfoUtil.fetchMessages(remoteInfo);
                    for (CMessage msg : messages) {
                        this.getMessageSender().send(msg);
                    }
                    LOG.debug("NodeRecord validated: {}", new Object[]{remoteInfo});
                    this.privateSendNodeInfoArrived(remoteInfo);
                    this.privateSendNotifyNodeRecordUpdated(remoteAddress);
                } else {
                    LOG.error("Invalid NodeRecord");
                }
            }
        } else {
            CNodeAddress nextNode;
            UUID instance = CRecordNetworkGetNodeRecord.getInstance((CRecord)aRecord, null);
            CNodeInfoDto remoteInfo = this.getOrCreateNodeRecord(remoteAddress, instance);
            CNodeInfoDto localInfo = this.getOrCreateNodeRecord(CNodeAddress.getLocal());
            CRecord nodeInfoRecord = CNodeInfoUtil.createRecord(localInfo);
            String sequence = localInfo.getMyPacketBuilderSequence();
            if (CUtilString.isEmpty((String)sequence)) {
                sequence = this.getMyPacketBuilderSequence();
                CRecordDataNodeInfo.setPacketBuilderSequence((CRecord)nodeInfoRecord, (String)sequence);
            }
            CRecordNetworkGetNodeRecord.setNodeInfo((CRecord)aRecord, (CRecord)nodeInfoRecord);
            SecretKey sessionKey = CNodeInfoUtil.getMySessionKey(remoteInfo);
            byte[] publicKeyBytes = CRecordNetworkGetNodeRecord.getPublicKey((CRecord)aRecord, null);
            if (publicKeyBytes != null) {
                PublicKey publicKey = CKeyHelper.decodePublicKey(publicKeyBytes);
                byte[] encryptedSessionKey = CKeyHelper.encryptSessionKey(sessionKey, publicKey);
                CRecordNetworkGetNodeRecord.setSessionKey((CRecord)aRecord, (byte[])encryptedSessionKey);
                long ts = localInfo.getTimestampMySessionKey();
                CRecordNetworkGetNodeRecord.setTimestampSessionKey((CRecord)aRecord, (long)ts);
            }
            if ((nextNode = this.getNextNode(remoteAddress)) == null && remoteAddress.getSegmentId().isLocal()) {
                aEnvelope.setBlocked(true);
                this.mPendingAnswers.add(new CMessage(aEnvelope, aRecord));
            }
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    @Nullable
    private CNodeAddress getNextNode(@NotNull CNodeAddress aRemoteAddress) {
        IRouter router = (IRouter)CServiceRegistry.getInstance().getService(IRouter.class);
        if (router != null) {
            return router.getNextNode(aRemoteAddress, true);
        }
        return null;
    }

    private void privateSendNotifyNodeRecordUpdated(@NotNull CNodeAddress aRemoteNode) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord rec = CRecordNetworkNotifyNodeRecordUpdated.create();
        CRecordNetworkNotifyNodeRecordUpdated.setRemoteNode((CRecord)rec, (CNodeAddress)aRemoteNode);
        this.sendNotification(env, rec);
    }

    @NotNull
    public String getMyPacketBuilderSequence() {
        return this.mMyPacketBuilderSequence;
    }

    @NotNull
    public Collection<CNodeInfo> getNodeInfo(@NotNull Collection<CNodeAddress> aNodeAddresses) {
        return this.mNodeInfoList.getNodeInfos(aNodeAddresses);
    }

    @NotNull
    public Collection<CNodeInfoDto> getNodeInfoDtoCollection() {
        return this.mNodeInfoList.getNodeInfoDtoCollection();
    }

    @Nullable
    public CNodeInfoDto getNodeInfo(@NotNull CNodeAddress aNodeAddress) {
        return this.mNodeInfoList.get(aNodeAddress);
    }

    @NotNull
    public CNodeInfoDto getLocalNodeInfo() {
        return this.mLocalNodeInfo;
    }

    @NotNull
    public CNodeInfoDto getOrCreateNodeRecord(@NotNull CNodeAddress aNodeAddress) {
        return this.mNodeInfoList.getOrCreateNodeRecord(aNodeAddress);
    }

    @NotNull
    public CNodeInfoDto getOrCreateNodeRecord(@NotNull CNodeAddress aNodeAddress, @NotNull UUID aInstance) {
        return this.mNodeInfoList.getOrCreateNodeRecord(aNodeAddress, aInstance);
    }

    @NotNull
    public String getPacketBuilderSequence(@NotNull CMessage aMessage) {
        CEnvelope env = aMessage.getEnvelope();
        CNodeAddress remoteNodeAddress = env.getReceiver().getNamespaceAddress().getNodeAddress();
        CNodeInfoDto remoteInfo = this.getOrCreateNodeRecord(remoteNodeAddress);
        String sequence = "M";
        if (remoteInfo.isValidated() && CUtilString.isEmpty((String)(sequence = env.getPacketBuilderSequence())) && CUtilString.isEmpty((String)(sequence = remoteInfo.getHisPacketBuilderSequence()))) {
            sequence = this.getMyPacketBuilderSequence();
        }
        return sequence;
    }

    public void remove(@NotNull CNodeAddress aNodeAddress) {
        this.mNodeInfoList.remove(aNodeAddress);
    }

    public void updateNodeInfo(@NotNull CNodeInfoDto aDto) {
        String pbs;
        String vendor;
        UUID license;
        String description;
        CNodeAddress nodeAddress = aDto.getNodeAddress();
        UUID instance = aDto.getInstanceId();
        CNodeInfoDto dto = this.getOrCreateNodeRecord(nodeAddress, instance);
        dto.setTypeOfNode(aDto.getTypeOfNode());
        String name = aDto.getName();
        if (CUtilString.isValid((String)name)) {
            dto.setName(name);
        }
        if (CUtilString.isValid((String)(description = aDto.getDescription()))) {
            dto.setDescription(description);
        }
        if (CUtilUuid.isValid((UUID)(license = aDto.getLicense()))) {
            dto.setLicense(license);
        }
        if (CUtilString.isValid((String)(vendor = aDto.getVendor()))) {
            dto.setVendor(vendor);
        }
        if (CUtilString.isValid((String)(pbs = aDto.getHisPacketBuilderSequence()))) {
            dto.setHisPacketBuilderSequence(pbs);
        }
    }

    private void addLocalNodeToList() {
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        CNodeAddress nodeAddress = kc.getNodeAddress();
        String name = kc.getName();
        String vendor = kc.getVendor();
        String description = kc.getDescription();
        UUID license = kc.getLicense();
        UUID instanceId = kc.getInstanceId();
        this.mLocalNodeInfo = this.getOrCreateNodeRecord(nodeAddress);
        this.mLocalNodeInfo.setName(name);
        this.mLocalNodeInfo.setVendor(vendor);
        this.mLocalNodeInfo.setDescription(description);
        this.mLocalNodeInfo.setLicense(license);
        this.mLocalNodeInfo.setInstanceId(instanceId);
        this.mLocalNodeInfo.setTypeOfNode(kc.getTypeOfNode());
    }

    public void requestRemoteNodeInfo(@NotNull CNodeAddress aRemoteAddress, boolean aForce) throws CException {
        CNodeInfoDto remoteInfo = this.getOrCreateNodeRecord(aRemoteAddress);
        if (!(remoteInfo.isRecordRequested() || !aForce && remoteInfo.isValidated())) {
            CNodeInfoUtil.requestRecord(remoteInfo);
            LOG.debug("Request GetNodeRecord to {}.", new Object[]{aRemoteAddress});
            CEnvelope env = CEnvelope.forSingleTarget((IId)this.getAddress().getTID(), (IId)this.getAddress().getNID(), (CNodeAddress)aRemoteAddress);
            env.setRawTransport();
            CRecord rec = CRecordNetworkGetNodeRecord.create();
            KeyPair keyPair = CKeyHelper.getOrCreateMyRsaKey();
            PublicKey publicKey = keyPair.getPublic();
            byte[] encodedPublicKey = CKeyHelper.encodePublicKey(publicKey);
            CRecordNetworkGetNodeRecord.setPublicKey((CRecord)rec, (byte[])encodedPublicKey);
            CRecordNetworkGetNodeRecord.setInstance((CRecord)rec, (UUID)this.mDependencies.getKernelConfiguration().getInstanceId());
            this.sendRequest(env, rec);
        }
    }

    public void processPendingAnswers() throws CException {
        Iterator<CMessage> it = this.mPendingAnswers.iterator();
        while (it.hasNext()) {
            CMessage msg = it.next();
            CNodeAddress node = msg.getEnvelope().getSender().getNamespaceAddress().getNodeAddress();
            CNodeAddress nextNode = this.getNextNode(node);
            if (nextNode == null) continue;
            it.remove();
            msg.getEnvelope().setBlocked(false);
            this.getMessageSender().sendBack(msg);
        }
    }

    public void sendNotifyRemoteNodeAdded(@NotNull CNodeInfoDto aNodeInfo) throws CException {
        AtomicBoolean sent = aNodeInfo.getNotifyRemoteNodeAddedSent();
        if (sent.compareAndSet(false, true)) {
            CNodeAddress nodeAddress = aNodeInfo.getNodeAddress();
            if (LOG_NODE.isDebugEnabled()) {
                LOG_NODE.debug("Remote Node added: {}", new Object[]{nodeAddress});
                LOG_NODE.debug(aNodeInfo.dump());
            }
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordNotifyRemoteNodeAdded.class);
            CRecord rec = CRecordNotifyRemoteNodeAdded.create();
            CRecordNotifyRemoteNodeAdded.setRemoteNode((CRecord)rec, (CNodeAddress)nodeAddress);
            CRecordNotifyRemoteNodeAdded.setType((CRecord)rec, (String)(aNodeInfo.isClient() ? ETypeOfNode.CLIENT.name() : ETypeOfNode.SERVER.name()));
            this.sendNotification(env, rec);
            aNodeInfo.getNotifyRemoteNodeRemovedSent().set(false);
        }
    }

    public void sendNotifyRemoteNodeRemoved(@NotNull CNodeInfoDto aNodeInfo) throws CException {
        AtomicBoolean sent = aNodeInfo.getNotifyRemoteNodeRemovedSent();
        if (sent.compareAndSet(false, true)) {
            CNodeAddress nodeAddress = aNodeInfo.getNodeAddress();
            if (LOG_LOST.isDebugEnabled()) {
                LOG_LOST.debug("Remote Node removed: {}", new Object[]{nodeAddress});
                LOG_LOST.debug(aNodeInfo.dump());
            }
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordNotifyRemoteNodeRemoved.class);
            CRecord rec = CRecordNotifyRemoteNodeRemoved.create();
            CRecordNotifyRemoteNodeRemoved.setRemoteNode((CRecord)rec, (CNodeAddress)nodeAddress);
            this.sendNotification(env, rec);
            aNodeInfo.getNotifyRemoteNodeAddedSent().set(false);
        }
    }

    private void privateSendNodeInfoArrived(@NotNull CNodeInfoDto aNode) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkNotifyNodeInfoArrived.class);
        CRecord rec = CRecordNetworkNotifyNodeInfoArrived.create();
        CRecord payloadRecord = CNodeInfoUtil.createRecord(aNode);
        CRecordNetworkNotifyNodeInfoArrived.setNodeInfo((CRecord)rec, (CRecord)payloadRecord);
        this.sendNotification(env, rec);
    }
}

