/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.jsonmessage;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.IDependencies;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class CJsonHolder {
    private static final ILogger JSON_MSG_JSON_LOG = CLoggerFactory.getLogger((String)"network.message.json");
    private static final int BUILDER_SIZE = 200;
    private final IDependencies mDependencies;
    private final String mType;
    private CJsonObject mRoot;
    private byte[] mPackedJson;

    CJsonHolder(@NotNull IDependencies aDependencies, @NotNull String aType) {
        this.mDependencies = aDependencies;
        this.mType = aType;
    }

    CJsonObject getRoot() {
        return this.mRoot;
    }

    void setBytes(byte[] aBytes) {
        this.mPackedJson = aBytes;
    }

    void setJsonObject(@NotNull CJsonObject aRoot) {
        this.mRoot = aRoot;
    }

    byte[] getPackedJson() {
        return this.mPackedJson;
    }

    void pack() throws CException {
        if (this.mPackedJson == null) {
            if (this.mRoot == null) {
                throw new CException(4).append("No Root");
            }
            StringBuilder sb = new StringBuilder(200);
            this.mDependencies.getWriter().write(sb, (Object)this.mRoot);
            String s = sb.toString();
            JSON_MSG_JSON_LOG.trace("JSON out {}: {}", new Object[]{this.mType, s});
            this.mPackedJson = s.getBytes(StandardCharsets.UTF_8);
        }
    }

    void unpack() throws CException {
        if (this.mRoot == null) {
            if (this.mPackedJson == null) {
                throw new CException(4).append("No Bytes");
            }
            String s = new String(this.mPackedJson, StandardCharsets.UTF_8);
            JSON_MSG_JSON_LOG.trace("JSON in {}: {}", new Object[]{this.mType, s});
            this.mRoot = this.mDependencies.getParser().parse(s, true);
        }
    }
}

