/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessageHeaderFactory;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketBuilderRegistry;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.network.packets.IPacketFactoryRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderFactoryRegistry;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderList;
import de.sillysky.nyssr.util.streamheader.IStreamHeaderFactory;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class CPacketFactoryMessage
implements IPacketFactory,
IService {
    private CStreamHeaderFactoryRegistry<CPacketMessage> mHeaderFactoryRegistry;
    private CNodeAddress mLocalNode;
    private IPacketBuilderRegistry mPacketBuilderService;
    private INodeInfoDatabase mNodeInfoDatabase;
    private int mRunningNo = 0;

    CPacketFactoryMessage() {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getService(INodeInfoDatabase.class);
        this.mPacketBuilderService = (IPacketBuilderRegistry)aServiceRegistry.getService(IPacketBuilderRegistry.class);
        IKernelConfiguration kc = (IKernelConfiguration)aServiceRegistry.getService(IKernelConfiguration.class);
        assert (kc != null);
        this.mLocalNode = kc.getNodeAddress();
        this.mHeaderFactoryRegistry = new CStreamHeaderFactoryRegistry();
        CPacketMessageHeaderFactory factory = new CPacketMessageHeaderFactory();
        this.mHeaderFactoryRegistry.registerFactory(1, (IStreamHeaderFactory)factory);
        this.mHeaderFactoryRegistry.registerFactory(2, (IStreamHeaderFactory)factory);
        this.mHeaderFactoryRegistry.registerFactory(3, (IStreamHeaderFactory)factory);
        IPacketFactoryRegistry cpf = (IPacketFactoryRegistry)aServiceRegistry.getService(IPacketFactoryRegistry.class);
        assert (cpf != null);
        cpf.registerPacketFactory(this);
    }

    @Override
    @NotNull
    public IPacket fromObject(@NotNull Object aObject) {
        ++this.mRunningNo;
        if (this.mRunningNo < 0) {
            this.mRunningNo = 0;
        }
        return new CPacketMessage(this.mNodeInfoDatabase, this.mPacketBuilderService, (CMessage)aObject, this.mRunningNo, this.mLocalNode);
    }

    @Override
    @NotNull
    public IPacket fromStream(@NotNull DataInput aStream, boolean aIsTest) throws IOException {
        CStreamHeaderList list = new CStreamHeaderList();
        list.unpack(aStream, null, this.mHeaderFactoryRegistry);
        return new CPacketMessage(this.mNodeInfoDatabase, this.mPacketBuilderService, (CStreamHeaderList<CPacketMessage>)list);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketFactoryRegistry cpf = (IPacketFactoryRegistry)aServiceRegistry.getService(IPacketFactoryRegistry.class);
        if (cpf != null) {
            cpf.deregisterPacketFactory(this);
        }
    }

    @Override
    public EPacketType getType() {
        return EPacketType.MESSAGE;
    }
}

