/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.ping;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.costs.records.CRecordAddNewLocalLinkCost;
import de.sillysky.nyssr.impl.network.packet.factory.ping.CPacketPing;
import de.sillysky.nyssr.impl.network.ping.ITargetLinkCosts;
import de.sillysky.nyssr.impl.network.records.CRecordPingTimer;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacketContext;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.network.packets.IPacketFactoryRegistry;
import de.sillysky.nyssr.network.records.CRecordNetworkRouterPing;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

class CTargetLinkCosts
extends CTarget
implements ITargetLinkCosts {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetLinkCosts.class);
    private static final long TIMEOUT_PING = 3000L;
    private static final long MILLION = 1000000L;
    private final ITimerManager mTimerManager;
    private final IPacketContext mPacketContext;
    private CTimer mPingTimer;

    CTargetLinkCosts(@NotNull ITimerManager aTimerManager, @NotNull IPacketContext aPacketContext) {
        this.mTimerManager = aTimerManager;
        this.mPacketContext = aPacketContext;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordPingTimer.ID, this::asyncPingTimer);
        this.addMessageHandler(CRecordNetworkRouterPing.ID, this::asyncReflectedPingFromRemote);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mPingTimer = new CTimer(this.mTimerManager, CRecordPingTimer.ID, this.getAddress(), 3000L, false, null);
        this.mPingTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncPingTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mPingTimer.notifyTriggerOccurred();
        this.sendPing(System.nanoTime());
        this.mPingTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncReflectedPingFromRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        long timestamp = CRecordNetworkRouterPing.getTimestamp((CRecord)aRecord, (long)0L);
        long elapsed = System.nanoTime() - timestamp;
        long elapsedMs = elapsed / 1000000L;
        this.sendCostsToLocalCostCollector(this.mPacketContext.getRemoteNode().getNodeId(), (int)elapsedMs);
        LOG.debug("costs from {} to {} = {} ns or {} ms", new Object[]{this.getAddress().getNodeId(), this.mPacketContext.getRemoteNode(), elapsed, elapsedMs});
        aEnvelope.setResultSuccess();
        return true;
    }

    private void sendCostsToLocalCostCollector(@NotNull CNodeId aNode, int aCosts) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordAddNewLocalLinkCost.create();
        CRecordAddNewLocalLinkCost.setNodeId(record, aNode);
        CRecordAddNewLocalLinkCost.setCosts(record, aCosts);
        this.sendNotification(env, record);
    }

    private void sendPing(long aTime) {
        IPacketFactoryRegistry packetFactoryRegistry = this.mPacketContext.getPacketFactoryRegistry();
        IPacketFactory factory = packetFactoryRegistry.getPacketFactory(EPacketType.PING);
        if (factory != null) {
            CPacketPing pp = new CPacketPing(false, aTime);
            try {
                pp.pack();
                this.mPacketContext.sendPacketToTransportLayer(pp, false);
            }
            catch (CException e) {
                LOG.error("error sending ping packet to transport layer");
                this.deregisterTarget();
            }
        }
    }

    @Override
    public void dismiss() {
        this.deregisterTarget();
    }
}

