/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.util;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilZip {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.zip");
    private static final int RESERVED = 1000;
    private static final int BUFFER_SIZE = 500;

    private CUtilZip() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte @Nullable [] pack(byte @NotNull [] aBytes, @NotNull ILogger aLogger) {
        int unpackedSize = aBytes.length;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(unpackedSize + 1000);
             GZIPOutputStream zip = new GZIPOutputStream(baos);){
            zip.write(aBytes, 0, unpackedSize);
            zip.flush();
            zip.finish();
            int packedSize = baos.size();
            byte[] result = baos.toByteArray();
            if (packedSize >= unpackedSize) return null;
            int percentage = 100 - 100 * packedSize / unpackedSize;
            LOG.debug("ZIP: pack lengthBefore={}, lengthAfter={}, gain={}%", new Object[]{unpackedSize, packedSize, percentage});
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            aLogger.error((Throwable)e, "Error zipping message.");
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static byte @NotNull [] unpackZip(byte @NotNull [] aBytes, @NotNull ILogger aLogger) throws CException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

