/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.records.CRecordAppAddPreset;
import de.sillysky.nyssr.app.records.CRecordAppChangePresetProperty;
import de.sillysky.nyssr.app.records.CRecordAppDeletePreset;
import de.sillysky.nyssr.app.records.CRecordAppDeletePresetProperty;
import de.sillysky.nyssr.app.records.CRecordAppGetDescriptionById;
import de.sillysky.nyssr.app.records.CRecordAppGetPreset;
import de.sillysky.nyssr.app.records.CRecordAppGetPresetList;
import de.sillysky.nyssr.app.records.CRecordAppRenamePreset;
import de.sillysky.nyssr.app.records.CRecordAppRunApplication;
import de.sillysky.nyssr.app.records.CRecordDataApplication;
import de.sillysky.nyssr.app.records.CRecordDataApplicationPreset;
import de.sillysky.nyssr.app.records.CRecordNotifyAppInstanceStopped;
import de.sillysky.nyssr.dialog.preset.records.CRecordOpenDialogPreset;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.dialog.preset.CPreset;
import de.sillysky.nyssr.impl.dialog.preset.CPresetList;
import de.sillysky.nyssr.impl.dialog.preset.CPresetModel;
import de.sillysky.nyssr.impl.dialog.preset.CPresetUi;
import de.sillysky.nyssr.impl.dialog.preset.IDialogPresetDependencies;
import de.sillysky.nyssr.impl.dialog.preset.editproperty.CEditPropertyTarget;
import de.sillysky.nyssr.impl.dialog.preset.newpreset.CNewPresetTarget;
import de.sillysky.nyssr.impl.dialog.preset.records.CRecordDlgEditPropertyClosed;
import de.sillysky.nyssr.impl.dialog.preset.records.CRecordDlgNewPresetClosed;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.records.CRecordAddMessages;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.events.CEventOnTableCellNotification;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialog;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.CStringProperty;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPresetTarget
extends CBasicDialog {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.preset");
    private static final String[] JSON = new String[]{"/json/600_Presets.json", "/json/603_PopupPreset.json", "/json/604_PopupPresetProperties.json", "/json/605_FormApplication.json", "/json/602_EditProperty.json", "/json/601_NewPreset.json"};
    @NonNls
    private static final String APPLICATION_NOT_AVAILABLE = "-- Application not available (PlugIn not loaded, see configuration) --";
    private final CPresetModel mModel;
    private CPresetUi mUi;
    private CEditPropertyTarget mTargetEditProperty = null;
    private CNewPresetTarget mTargetNewPreset = null;

    public CPresetTarget(@NotNull IDialogPresetDependencies aDependencies, @NotNull CDialogDto aDialogDto, @NotNull CRecord aRecord) {
        super(aDependencies.getNamespaceRegistry(), aDependencies.getRemoteSkinServerContextFactory(), aDependencies.getWidgetSetLoader(), aDialogDto);
        CNodeAddress nodeAddressOfAppStore = CRecordOpenDialogPreset.getNodeAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)nodeAddressOfAppStore, (String)"Node Address of App Store missing", (Object[])new Object[0]);
        CTargetAddress addressForDisplayingMessages = CRecordOpenDialogPreset.getAddressForDisplayingMessages((CRecord)aRecord, null);
        this.mModel = new CPresetModel(aDependencies, aDialogDto, nodeAddressOfAppStore, addressForDisplayingMessages, this);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAppGetPresetList.ID, this::asyncAnswerGetPresets);
        this.addMessageHandler(CRecordAppGetDescriptionById.ID, this::asyncAnswerGetApplicationDescription);
        this.addMessageHandler(CRecordAppAddPreset.ID, this::asyncAnswerRegisterApplicationPreset);
        this.addMessageHandler(CRecordAppDeletePreset.ID, this::asyncAnswerDeregisterApplicationPreset);
        this.addMessageHandler(CRecordDlgNewPresetClosed.ID, this::asyncDlgNewPresetClosed);
        this.addMessageHandler(CRecordAppRenamePreset.ID, this::asyncAnswerRenamePreset);
        this.addMessageHandler(CRecordAppChangePresetProperty.ID, this::asyncAnswerChangeProperty);
        this.addMessageHandler(CRecordAppGetPreset.ID, this::asyncAnswerGetPreset);
        this.addMessageHandler(CRecordDlgEditPropertyClosed.ID, this::asyncDlgEditPropertyClosed);
        this.addMessageHandler(CRecordAppDeletePresetProperty.ID, this::asyncAnswerDeleteProperty);
        this.addMessageHandler(CRecordNotifyAppInstanceStopped.ID, this::asyncNotifyAppInstanceStopped);
        this.addMessageHandler(CRecordAppRunApplication.ID, this::asyncAnswerStartApp);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        LOG.info("Start Preset Target");
        super.startTarget(aEnvelope, aRecord);
        this.mUi = new CPresetUi(this.mModel);
        this.mUi.mountWidgetSet600();
        this.sendGetPresets();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerChangeProperty(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String name = CRecordAppChangePresetProperty.getPresetName((CRecord)aRecord, (String)"");
            String key = CRecordAppChangePresetProperty.getPropertyKey((CRecord)aRecord, (String)"");
            String value = CRecordAppChangePresetProperty.getPropertyValue((CRecord)aRecord, (String)"");
            int code = aEnvelope.getResultCode();
            if (code == 0) {
                this.addMessage(false, "Successfully changed Property for %s: key=%s, value=%s", name, key, value);
                CPresetList pl = this.mModel.getPresetList();
                String name1 = pl.getNameOfSelectedPreset();
                if (name1 != null) {
                    this.sendGetPreset(name1);
                }
            } else {
                this.addMessage(true, "Error changing Preset Property: %d: %s", code, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerDeleteProperty(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String name = CRecordAppDeletePresetProperty.getPresetName((CRecord)aRecord, (String)"");
            String key = CRecordAppDeletePresetProperty.getPropertyKey((CRecord)aRecord, (String)"");
            int code = aEnvelope.getResultCode();
            if (code == 0) {
                this.addMessage(false, "Successfully deleted Property for %s: key=%s", name, key);
                CPresetList pl = this.mModel.getPresetList();
                String name2 = pl.getNameOfSelectedPreset();
                if (name2 != null) {
                    this.sendGetPreset(name2);
                }
            } else {
                this.addMessage(true, "Error deleting Preset Property: %d: %s", code, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerDeregisterApplicationPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mModel.getPresetList().selectFirst();
                this.sendGetPresets();
            } else {
                String name = CRecordAppDeletePreset.getPresetName((CRecord)aRecord, (String)"");
                LOG.error("Error deregister Preset {}: {}", new Object[]{name, aEnvelope.getResultText()});
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerGetApplicationDescription(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            String name = APPLICATION_NOT_AVAILABLE;
            String shortDesc = APPLICATION_NOT_AVAILABLE;
            String longDesc = APPLICATION_NOT_AVAILABLE;
            UUID applicationId = CRecordAppGetDescriptionById.getApplicationId((CRecord)aRecord, null);
            CRecord rec = CRecordAppGetDescriptionById.getApplicationDescription((CRecord)aRecord, null);
            if (rec != null) {
                name = CRecordDataApplication.getName((CRecord)rec, (String)APPLICATION_NOT_AVAILABLE);
                shortDesc = CRecordDataApplication.getShortDescription((CRecord)rec, (String)APPLICATION_NOT_AVAILABLE);
                longDesc = CRecordDataApplication.getLongDescription((CRecord)rec, (String)APPLICATION_NOT_AVAILABLE);
            }
            this.mUi.update(applicationId, name, shortDesc, longDesc);
            aEnvelope.setResultSuccess();
            return true;
        }
        return false;
    }

    private boolean asyncAnswerGetPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CRecord rec;
            if (aEnvelope.getResultCode() == 0 && (rec = CRecordAppGetPreset.getApplicationPreset((CRecord)aRecord, null)) != null) {
                CPreset p = this.extractPreset(rec);
                this.mModel.getPresetList().add(p);
                this.mUi.fillProperties(p.getName());
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerGetPresets(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CRecord[] applicationPresetList = CRecordAppGetPresetList.getApplicationPresetList((CRecord)aRecord, null);
            if (applicationPresetList != null) {
                CPresetList pl = this.mModel.getPresetList();
                pl.clear();
                for (CRecord rec : applicationPresetList) {
                    CPreset preset = this.extractPreset(rec);
                    pl.add(preset);
                }
                this.updatePresetList(pl);
            }
            return true;
        }
        return false;
    }

    private void updatePresetList(@NotNull CPresetList aPl) {
        if (this.mModel.isWs600Loaded()) {
            this.mUi.updatePresetList(aPl.getPresetNames());
            this.mUi.ensurePresetIsSelected();
            this.mUi.sendUpdate();
        }
    }

    private boolean asyncAnswerRegisterApplicationPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                this.addMessage(true, "Error creating new Preset: %d - %s", resultCode, aEnvelope.getResultText());
            } else {
                CRecord rec = CRecordAppAddPreset.getApplicationPreset((CRecord)aRecord, null);
                String presetName = CRecordDataApplicationPreset.getPresetName((CRecord)rec, (String)"");
                this.addMessage(false, "Successfully created Preset %s", presetName);
                this.mUi.selectPreset(presetName);
                this.sendGetPresets();
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerRenamePreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                this.addMessage(true, "Error renaming Preset: %d - %s", resultCode, aEnvelope.getResultText());
            } else {
                String oldPresetName = CRecordAppRenamePreset.getOldPresetName((CRecord)aRecord, null);
                String newPresetName = CRecordAppRenamePreset.getNewPresetName((CRecord)aRecord, null);
                this.addMessage(false, "Successfully renamed Preset %s to %s", oldPresetName, newPresetName);
                this.mUi.selectPreset(newPresetName);
                this.mUi.sendUpdate();
                this.sendGetPresets();
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerStartApp(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            String presetName = CRecordAppRunApplication.getPresetName((CRecord)aRecord, null);
            int code = aEnvelope.getResultCode();
            if (code == 0) {
                UUID instanceId = CRecordAppRunApplication.getInstanceId((CRecord)aRecord, null);
                IId nid = CRecordAppRunApplication.getNamespace((CRecord)aRecord, null);
                this.addMessage(false, "Successfully started App %s. InstanceId=%s, Namespace=%s", presetName, CUtilUuid.toShortString((UUID)instanceId), nid);
            } else {
                this.addMessage(true, "Couldn't start App %s: %s", presetName, aEnvelope.getResult());
            }
            aEnvelope.setResultSuccess();
            return true;
        }
        return false;
    }

    private boolean asyncDlgEditPropertyClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mTargetEditProperty = null;
        boolean okay = CRecordDlgEditPropertyClosed.getOkay(aRecord, false);
        if (okay) {
            CStringProperty property = CRecordDlgEditPropertyClosed.getProperty(aRecord, null);
            CPresetList pl = this.mModel.getPresetList();
            String presetName = pl.getNameOfSelectedPreset();
            if (presetName != null) {
                this.sendChangeProperty(pl.getNameOfSelectedPreset(), property.getKey(), property.getValue());
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDlgNewPresetClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mTargetNewPreset = null;
        boolean okay = CRecordDlgNewPresetClosed.getOkay(aRecord, false);
        if (okay) {
            String name = CRecordDlgNewPresetClosed.getPresetName(aRecord, null);
            this.mUi.selectPreset(name);
            this.sendGetPresets();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyAppInstanceStopped(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void editProperty(@NotNull String aKey, @NotNull String aValue, boolean aCreate) throws CException {
        if (this.mTargetEditProperty == null) {
            this.mTargetEditProperty = new CEditPropertyTarget(this.mModel, this.getAddress(), this.mUi.getPropertyTable(), aKey, aValue, aCreate);
            this.getTargetRegistry().registerTarget((ITarget)this.mTargetEditProperty);
        }
    }

    @NotNull
    private CPreset extractPreset(@NotNull CRecord rec) {
        UUID applicationId = CRecordDataApplicationPreset.getApplicationId((CRecord)rec, null);
        String name = CRecordDataApplicationPreset.getPresetName((CRecord)rec, null);
        CStringProperties properties = CRecordDataApplicationPreset.getProperties((CRecord)rec, null);
        return new CPreset(applicationId, name, properties);
    }

    void onChangeProperty(@NotNull CEventOnTableCellNotification aEvent) throws CException {
        String oldValue;
        CPreset preset;
        String rowId = aEvent.getRowId();
        String value = aEvent.getValue();
        CPresetList pl = this.mModel.getPresetList();
        String presetName = pl.getNameOfSelectedPreset();
        if (presetName != null && (preset = pl.get(presetName)) != null && !CUtilString.equals((String)(oldValue = preset.getProperties().get(rowId)), (String)value)) {
            this.sendChangeProperty(presetName, rowId, value);
        }
    }

    void onCopyPreset(@NotNull String aPresetName) {
        String presetName;
        CPresetList pl = this.mModel.getPresetList();
        CPreset preset = pl.get(presetName = CUtilString.isValid((String)aPresetName) ? aPresetName : pl.getNameOfSelectedPreset());
        if (preset == null) {
            this.addMessage(false, "Copy Preset: No Preset selected", new Object[0]);
        } else {
            this.mModel.setClipBoardPreset(preset);
            this.mUi.enableButtonPaste(true);
            this.mUi.sendUpdate();
            this.addMessage(false, "Preset %s copied to ClipBoard", preset.getName());
        }
    }

    void onDeletePreset(@NotNull String aPresetName) {
        String presetName;
        CPresetList pl = this.mModel.getPresetList();
        CPreset preset = pl.get(presetName = CUtilString.isValid((String)aPresetName) ? aPresetName : pl.getNameOfSelectedPreset());
        if (preset == null) {
            this.addMessage(false, "Deleting Preset: No Preset selected", new Object[0]);
        } else {
            this.mModel.setProcessedPreset(preset);
            this.mUi.askDeletePreset(presetName);
        }
    }

    void onDeleteProperty(@NotNull String aKey) {
        String presetName = this.mModel.getNameOfSelectedPreset();
        CPreset preset = this.mModel.getPreset(presetName);
        if (preset != null) {
            if (CUtilString.isValid((String)aKey)) {
                this.mModel.setProcessedPropertyKey(aKey);
                this.mUi.askDeleteProperty(aKey);
            } else {
                this.addMessage(false, "Deleting Property: No Property selected", new Object[0]);
            }
        } else {
            this.addMessage(false, "Deleting Property: No Preset selected", new Object[0]);
        }
    }

    void onNewProperty() throws CException {
        this.editProperty("", "", true);
    }

    void onEditProperty(@NotNull String aPropertyKey) throws CException {
        CPreset preset = this.mModel.getPresetList().getSelectedPreset();
        if (preset != null) {
            String propertyValue = preset.getProperties().get(aPropertyKey);
            this.editProperty(aPropertyKey, propertyValue, false);
        }
    }

    void onNewPreset() throws CException {
        if (this.mTargetNewPreset == null) {
            this.mTargetNewPreset = new CNewPresetTarget(this.mModel, this.getAddress(), this.mUi.getPresetListBox(), this.mModel.getPresetList().getPresetNames());
            this.getTargetRegistry().registerTarget((ITarget)this.mTargetNewPreset);
        }
    }

    void onPastePreset() throws CException {
        CPreset preset = this.mModel.getClipBoardPreset();
        if (preset == null) {
            this.addMessage(false, "Paste Preset: No Preset in ClipBoard!", new Object[0]);
        } else {
            this.mUi.enterPresetNameOnPaste();
        }
    }

    void onRenamePreset(@Nullable String aOldName, @Nullable String aNewName) throws CException {
        if (CUtilString.isEmpty((String)aNewName) || CUtilString.isEmpty((String)aOldName) || CUtilString.equals((String)aOldName, (String)aNewName)) {
            return;
        }
        CPresetList pl = this.mModel.getPresetList();
        CPreset preset = pl.get(aOldName);
        if (preset == null) {
            this.addMessage(false, "Rename Preset: No Preset selected", new Object[0]);
        } else {
            this.sendRenamePreset(aOldName, aNewName);
        }
    }

    void onRun(@NotNull String aName) throws CException {
        CPreset preset;
        if (CUtilString.isValid((String)aName) && (preset = this.mModel.getPresetList().get(aName)) != null) {
            this.addMessage(false, "Run %s", aName);
            this.sendRun(preset);
        }
    }

    void onSelectProperty(@NotNull String aPropertyKey) {
        this.mModel.setSelectedPropertyKey(aPropertyKey);
    }

    private void sendRun(@NotNull CPreset aPreset) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppRunApplication.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppRunApplication.create();
        CRecordAppRunApplication.setPresetName((CRecord)record, (String)aPreset.getName());
        CRecordAppRunApplication.setRemoteSkinClient((CRecord)record, (CNodeAddress)this.mModel.getDialogDto().getClientContext().getTargetAddress().getNodeAddress());
        CRecordAppRunApplication.setSessionToken((CRecord)record, (String)this.mModel.getDialogDto().getSessionToken());
        this.sendRequest(env, record);
    }

    private void sendChangeProperty(@NotNull String aPresetName, @NotNull String aPropertyKey, @NotNull String aPropertyValue) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppChangePresetProperty.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppChangePresetProperty.create();
        CRecordAppChangePresetProperty.setPresetName((CRecord)record, (String)aPresetName);
        CRecordAppChangePresetProperty.setPropertyKey((CRecord)record, (String)aPropertyKey);
        CRecordAppChangePresetProperty.setPropertyValue((CRecord)record, (String)aPropertyValue);
        this.sendRequest(env, record);
    }

    private void sendCreatePreset(@NotNull CPreset aPreset) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppAddPreset.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord recPreset = CRecordDataApplicationPreset.create();
        CRecordDataApplicationPreset.setPresetName((CRecord)recPreset, (String)aPreset.getName());
        CRecordDataApplicationPreset.setApplicationId((CRecord)recPreset, (UUID)aPreset.getAppId());
        CRecordDataApplicationPreset.setProperties((CRecord)recPreset, (CStringProperties)aPreset.getProperties());
        CRecord record = CRecordAppAddPreset.create();
        CRecordAppAddPreset.setApplicationPreset((CRecord)record, (CRecord)recPreset);
        this.sendRequest(env, record);
    }

    private void sendDeletePreset(@NotNull String aPreset) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppDeletePreset.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppDeletePreset.create();
        CRecordAppDeletePreset.setPresetName((CRecord)record, (String)aPreset);
        this.sendRequest(env, record);
    }

    private void sendDeleteProperty(@NotNull String aPresetName, @NotNull String aPropertyKey) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppDeletePresetProperty.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppDeletePresetProperty.create();
        CRecordAppDeletePresetProperty.setPresetName((CRecord)record, (String)aPresetName);
        CRecordAppDeletePresetProperty.setPropertyKey((CRecord)record, (String)aPropertyKey);
        this.sendRequest(env, record);
    }

    void sendGetApplicationDescription(@NotNull UUID aAppId) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppGetDescriptionById.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppGetDescriptionById.create();
        CRecordAppGetDescriptionById.setApplicationId((CRecord)record, (UUID)aAppId);
        this.sendRequest(env, record);
    }

    private void sendGetPreset(@NotNull String aPresetName) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppGetPreset.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppGetPreset.create();
        CRecordAppGetPreset.setPresetName((CRecord)record, (String)aPresetName);
        this.sendRequest(env, record);
    }

    void notifyWs600Loaded() {
        LOG.info("Ws600 loaded");
        this.mModel.setWs600Loaded();
        CPresetList presetList = this.mModel.getPresetList();
        if (!presetList.isEmpty()) {
            this.updatePresetList(presetList);
        }
    }

    private void sendGetPresets() throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppGetPresetList.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppGetPresetList.create();
        this.sendRequest(env, record);
    }

    private void sendRenamePreset(@NotNull String aOldName, @NotNull String aNewName) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAppRenamePreset.class, (CNodeAddress)this.mModel.getNodeAddressOfAppStore());
        CRecord record = CRecordAppRenamePreset.create();
        CRecordAppRenamePreset.setOldPresetName((CRecord)record, (String)aOldName);
        CRecordAppRenamePreset.setNewPresetName((CRecord)record, (String)aNewName);
        this.sendRequest(env, record);
    }

    public void addMessage(boolean aIsError, String aMessage, Object ... aArgs) {
        String s = String.format(aMessage, aArgs);
        if (aIsError) {
            LOG.error(s);
        } else {
            LOG.debug(s);
        }
        this.displayMessage(s);
    }

    void onAnswerDeleteProperty() {
        CPresetList pl = this.mModel.getPresetList();
        String presetName = pl.getNameOfSelectedPreset();
        String ppk = this.mModel.getProcessedPropertyKey();
        if (CUtilString.isValid((String)presetName) && CUtilString.isValid((String)ppk)) {
            this.addMessage(false, "Delete Property %s for Preset %s", ppk, presetName);
            try {
                this.sendDeleteProperty(presetName, ppk);
            }
            catch (CException aE) {
                this.addMessage(true, "Error deleting property %s for Preset %s: %s", ppk, presetName, aE.getCombinedText());
            }
        }
    }

    void onAnswerDeletePreset() {
        CPreset pp = this.mModel.getProcessedPreset();
        if (pp != null) {
            String name = pp.getName();
            this.addMessage(false, "Delete preset %s", name);
            try {
                this.sendDeletePreset(name);
                this.addMessage(false, "Preset %s deleted", name);
            }
            catch (CException aE) {
                this.addMessage(true, "Error deleting preset %s: %s", name, aE.getCombinedText());
            }
        }
    }

    void onEnterNewPresetName(@NotNull String aNewValue) {
        if (CUtilString.isEmpty((String)aNewValue)) {
            this.addMessage(false, "Pasting Preset not possible, Preset Name is empty", new Object[0]);
        } else {
            CPresetList pl = this.mModel.getPresetList();
            CPreset p = pl.get(aNewValue);
            if (p != null) {
                this.addMessage(false, "Pasting Preset not possible, Preset already exists", new Object[0]);
            } else {
                p = this.mModel.getClipBoardPreset();
                if (p != null) {
                    p.setName(aNewValue);
                    try {
                        this.sendCreatePreset(p);
                    }
                    catch (CException aE) {
                        LOG.error((Throwable)aE, "Error sending Save Preset");
                    }
                }
            }
        }
    }

    protected String[] getJsonFiles() {
        return JSON;
    }

    public void displayMessage(@NotNull String aText) {
        CTargetAddress address = this.mModel.getAddressForDisplayingMessages();
        if (address != null) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
                CRecord rec = CRecordAddMessages.create();
                CRecordAddMessages.setMessages((CRecord)rec, (String[])new String[]{aText});
                this.sendNotification(env, rec);
            }
            catch (CException aE) {
                LOG.error("Couldn't send Message {}", new Object[]{aText});
            }
        }
    }
}

