/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.preset.CPreset;
import de.sillysky.nyssr.impl.dialog.preset.CPresetList;
import de.sillysky.nyssr.impl.dialog.preset.CPresetModel;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventMouseNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventOnTableCellNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPopupNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.localevents.CEventStringInputDialogResult;
import de.sillysky.nyssr.remoteskin.model.util.EMessageBoxType;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.dialogs.IStringInputDialog;
import de.sillysky.nyssr.remoteskin.server.dialogs.IStringInputFactory;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IDialogButtonListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMouseListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IPopupListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITableChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITableSelectionListener;
import de.sillysky.nyssr.remoteskin.server.widgets.CMessageBox;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CPresetUi {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPresetUi.class);
    private static final String COLUMN_KEY = "key";
    private static final String COLUMN_VALUE = "value";
    private final CPresetModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetId m600ButtonNewPreset;
    private final CWidgetId m600ButtonCopyPreset;
    private final CWidgetId m600ButtonPastePreset;
    private final CWidgetId m600ButtonDeletePreset;
    private final CWidgetId m600ButtonRenamePreset;
    private final CWidgetId m600ButtonRun;
    private final CWidgetId m600ListPresets;
    private final CWidgetId m600TableProperties;
    private final CWidgetId m600ButtonNewProperty;
    private final CWidgetId m600ButtonDeleteProperty;
    private final CWidgetId m600ButtonChangeProperty;
    private final CWidgetSetId mWs600;
    private final CWidgetSetId mWs603;
    private final CWidgetSetId mWs604;
    private final CWidgetSetId mWs605;
    private final CWidgetId m603MenuItemNewPreset;
    private final CWidgetId m603MenuItemDeletePreset;
    private final CWidgetId m603MenuItemRenamePreset;
    private final CWidgetId m603MenuItemCopyPreset;
    private final CWidgetId m603MenuItemPastePreset;
    private final CWidgetId m603MenuItemRun;
    private final CWidgetId m604MenuItemDeleteProperty;
    private final CWidgetId m604MenuItemEditProperty;
    private final CWidgetId m605TfAppId;
    private final CWidgetId m605TfAppName;
    private final CWidgetId m605TfAppShortDescription;
    private final CWidgetId m605TfAppLongDescription;

    CPresetUi(@NotNull CPresetModel aModel) {
        this.mModel = aModel;
        this.mServerContext = this.mModel.getServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = aModel.getDialogDto().getParentWidgetId().getWidgetSetId().getInstance();
        this.mWs600 = CWidgetSetId.create((String)"@600_Presets", (String)instance);
        this.m600ButtonNewPreset = this.mWs600.createWidgetId("#600_Button_NewPreset");
        this.mApi.addListener(this.m600ButtonNewPreset, (IListener)((IButtonPressedListener)this::onButtonNewPreset));
        this.m600ButtonCopyPreset = this.mWs600.createWidgetId("#600_Button_CopyPreset");
        this.mApi.addListener(this.m600ButtonCopyPreset, (IListener)((IButtonPressedListener)this::onButtonCopyPreset));
        this.m600ButtonPastePreset = this.mWs600.createWidgetId("#600_Button_PastePreset");
        this.mApi.addListener(this.m600ButtonPastePreset, (IListener)((IButtonPressedListener)this::onButtonPastePreset));
        this.m600ButtonDeletePreset = this.mWs600.createWidgetId("#600_Button_DeletePreset");
        this.mApi.addListener(this.m600ButtonDeletePreset, (IListener)((IButtonPressedListener)this::onButtonDeletePreset));
        this.m600ButtonRenamePreset = this.mWs600.createWidgetId("#600_Button_RenamePreset");
        this.mApi.addListener(this.m600ButtonRenamePreset, (IListener)((IButtonPressedListener)this::onButtonRenamePreset));
        this.m600ButtonRun = this.mWs600.createWidgetId("#600_Button_Run");
        this.mApi.addListener(this.m600ButtonRun, (IListener)((IButtonPressedListener)this::onButtonRun));
        this.m600ListPresets = this.mWs600.createWidgetId("#600_List_PresetNames");
        this.mApi.addListener(this.m600ListPresets, (IListener)((IListSelectionListener)this::onSelectPreset));
        this.mApi.addListener(this.m600ListPresets, (IListener)((IMouseListener)this::onPresetListMouseClick));
        this.m600TableProperties = this.mWs600.createWidgetId("#600_Table_Properties");
        this.mApi.addListener(this.m600TableProperties, (IListener)((ITableChangeListener)this::onTableChangeForProperties));
        this.mApi.addListener(this.m600TableProperties, (IListener)((ITableSelectionListener)this::onTableSelectionForProperties));
        this.mApi.addListener(this.m600TableProperties, (IListener)((IMouseListener)this::onTableMouseListenerForProperties));
        this.m600ButtonChangeProperty = this.mWs600.createWidgetId("#600_Button_ChangeProperty");
        this.mApi.addListener(this.m600ButtonChangeProperty, (IListener)((IButtonPressedListener)this::onButtonChangeProperty));
        this.m600ButtonNewProperty = this.mWs600.createWidgetId("#600_Button_NewProperty");
        this.mApi.addListener(this.m600ButtonNewProperty, (IListener)((IButtonPressedListener)this::onButtonNewProperty));
        this.m600ButtonDeleteProperty = this.mWs600.createWidgetId("#600_Button_DeleteProperty");
        this.mApi.addListener(this.m600ButtonDeleteProperty, (IListener)((IButtonPressedListener)this::onButtonDeleteProperty));
        this.mWs603 = CWidgetSetId.create((String)"@603_PopupPreset", (String)instance);
        this.m603MenuItemNewPreset = this.mWs603.createWidgetId("#603_NewPreset");
        this.mApi.addListener(this.m603MenuItemNewPreset, (IListener)((IPopupListener)this::onMenuItemNewPreset));
        this.m603MenuItemDeletePreset = this.mWs603.createWidgetId("#603_DeletePreset");
        this.mApi.addListener(this.m603MenuItemDeletePreset, (IListener)((IPopupListener)this::onMenuItemDeletePreset));
        this.m603MenuItemRenamePreset = this.mWs603.createWidgetId("#603_RenamePreset");
        this.mApi.addListener(this.m603MenuItemRenamePreset, (IListener)((IPopupListener)this::onMenuItemRenamePreset));
        this.m603MenuItemCopyPreset = this.mWs603.createWidgetId("#603_CopyPreset");
        this.mApi.addListener(this.m603MenuItemCopyPreset, (IListener)((IPopupListener)this::onMenuItemCopyPreset));
        this.m603MenuItemPastePreset = this.mWs603.createWidgetId("#603_PastePreset");
        this.mApi.addListener(this.m603MenuItemPastePreset, (IListener)((IPopupListener)this::onMenuItemPastePreset));
        this.m603MenuItemRun = this.mWs603.createWidgetId("#603_Run");
        this.mApi.addListener(this.m603MenuItemRun, (IListener)((IPopupListener)this::onMenuItemRun));
        this.mWs604 = CWidgetSetId.create((String)"@604_PopupPresetProperties", (String)instance);
        this.m604MenuItemDeleteProperty = this.mWs604.createWidgetId("#604_DeleteProperty");
        this.mApi.addListener(this.m604MenuItemDeleteProperty, (IListener)((IPopupListener)this::onPopupDeleteProperty));
        this.m604MenuItemEditProperty = this.mWs604.createWidgetId("#604_EditProperty");
        this.mApi.addListener(this.m604MenuItemEditProperty, (IListener)((IPopupListener)this::onPopupEditProperty));
        this.mWs605 = CWidgetSetId.create((String)"@605_FormApplication", (String)instance);
        this.m605TfAppId = this.mWs605.createWidgetId("#605_TextField_AppId");
        this.m605TfAppName = this.mWs605.createWidgetId("#605_TextField_AppName");
        this.m605TfAppShortDescription = this.mWs605.createWidgetId("#605_TextField_AppShortDescription");
        this.m605TfAppLongDescription = this.mWs605.createWidgetId("#605_TextField_AppLongDescription");
    }

    private void widgetSet600Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs600.equals((Object)aWidgetSetId)) {
            this.mModel.getPresetTarget().notifyWs600Loaded();
            this.sendUpdate();
        }
    }

    private void onButtonRun(@NotNull CEventButtonPressedNotification aCEvent) throws CException {
        String presetName = this.mModel.getNameOfSelectedPreset();
        if (CUtilString.isValid((String)presetName)) {
            this.mModel.getPresetTarget().onRun(presetName);
        }
    }

    private void onMenuItemRun(@NotNull CEventPopupNotification aValues) throws CException {
        String presetName = aValues.getValue();
        if (CUtilString.isValid((String)presetName)) {
            this.mModel.getPresetTarget().onRun(presetName);
        }
    }

    private void onButtonChangeProperty(@NotNull CEventButtonPressedNotification aValues) throws CException {
        String key = this.mModel.getSelectedPropertyKey();
        if (CUtilString.isValid((String)key)) {
            this.mModel.getPresetTarget().onEditProperty(key);
        }
    }

    private void onButtonNewProperty(@NotNull CEventButtonPressedNotification aValues) throws CException {
        this.mModel.getPresetTarget().onNewProperty();
    }

    private void onPopupEditProperty(@NotNull CEventPopupNotification aEvent) throws CException {
        this.editProperty(aEvent.getRowId());
    }

    private void onPopupDeleteProperty(@NotNull CEventPopupNotification aValues) {
        this.mModel.getPresetTarget().onDeleteProperty(aValues.getRowId());
    }

    private void onButtonDeleteProperty(@NotNull CEventButtonPressedNotification aValues) {
        String key = this.mModel.getSelectedPropertyKey();
        if (CUtilString.isValid((String)key)) {
            this.mModel.getPresetTarget().onDeleteProperty(key);
        }
    }

    private void onTableMouseListenerForProperties(@NotNull CEventMouseNotification aEvent) throws CException {
        this.editProperty(aEvent.getRowId());
    }

    private void editProperty(@NotNull String aRowId) throws CException {
        this.mModel.getPresetTarget().onEditProperty(aRowId);
    }

    private void onTableSelectionForProperties(@NotNull CEventTableSelectionNotification aEvent) {
        boolean enableButtons = false;
        Collection rows = aEvent.getSelectedRowIds();
        if (rows != null) {
            for (String row : rows) {
                String data = CUtilString.notNull((String)row);
                this.mModel.getPresetTarget().onSelectProperty(data);
                enableButtons = true;
            }
        }
        this.mApi.setEnabled(this.m600ButtonChangeProperty, enableButtons);
        this.mServerContext.sendUpdate();
    }

    void onPresetListMouseClick(@NotNull CEventMouseNotification aMouseEvent) throws CException {
        String value = aMouseEvent.getValue();
        this.renamePreset(value);
    }

    void onSelectPreset(@NotNull CEventListSelectionNotification aEvent) throws CException {
        block1: {
            List selectedIds = aEvent.getSelectedIds();
            Iterator iterator = selectedIds.iterator();
            if (!iterator.hasNext()) break block1;
            String id = (String)iterator.next();
            this.fillProperties(id);
            CPreset preset = this.mModel.getPreset(id);
            if (preset != null) {
                this.selectPreset(preset.getName());
                this.mModel.getPresetTarget().sendGetApplicationDescription(preset.getAppId());
            }
            this.mServerContext.sendUpdate();
        }
    }

    void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    private void onTableChangeForProperties(@NotNull CEventOnTableCellNotification aValues) throws CException {
        this.mModel.getPresetTarget().onChangeProperty(aValues);
    }

    private void onButtonNewPreset(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mModel.getPresetTarget().onNewPreset();
    }

    private void onButtonCopyPreset(@NotNull CEventButtonPressedNotification aEvent) {
        this.mModel.getPresetTarget().onCopyPreset("");
    }

    private void onButtonPastePreset(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mModel.getPresetTarget().onPastePreset();
    }

    private void onButtonDeletePreset(@NotNull CEventButtonPressedNotification aEvent) {
        this.mModel.getPresetTarget().onDeletePreset("");
    }

    private void onButtonRenamePreset(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        String name = this.mModel.getNameOfSelectedPreset();
        if (CUtilString.isValid((String)name)) {
            this.renamePreset(name);
        }
    }

    private void onMenuItemNewPreset(@NotNull CEventPopupNotification aEvent) throws CException {
        this.mModel.getPresetTarget().onNewPreset();
    }

    private void onMenuItemPastePreset(@NotNull CEventPopupNotification aEvent) throws CException {
        this.mModel.getPresetTarget().onPastePreset();
    }

    private void onMenuItemCopyPreset(@NotNull CEventPopupNotification aEvent) {
        this.mModel.getPresetTarget().onCopyPreset(aEvent.getValue());
    }

    private void onMenuItemRenamePreset(@NotNull CEventPopupNotification aEvent) throws CException {
        String name = aEvent.getValue();
        if (CUtilString.isValid((String)name)) {
            this.renamePreset(name);
        }
    }

    private void onMenuItemDeletePreset(@NotNull CEventPopupNotification aEvent) {
        this.mModel.getPresetTarget().onDeletePreset(aEvent.getValue());
    }

    CWidgetId getPropertyTable() {
        return this.m600TableProperties;
    }

    void enableButtonPaste(boolean aEnabled) {
        this.mApi.setEnabled(this.m600ButtonPastePreset, aEnabled);
    }

    CWidgetId getPresetListBox() {
        return this.m600ListPresets;
    }

    void ensurePresetIsSelected() {
        CPresetList pl = this.mModel.getPresetList();
        String selected = pl.getNameOfSelectedPreset();
        if (CUtilString.isEmpty((String)selected)) {
            selected = pl.selectFirst();
        }
        if (CUtilString.isValid((String)selected)) {
            this.mApi.selectItem(this.m600ListPresets, selected);
        }
    }

    void fillProperties(@NotNull String aPresetName) {
        this.mModel.setSelectedPropertyKey(null);
        CPreset preset = this.mModel.getPreset(aPresetName);
        if (preset != null) {
            CStringProperties properties = preset.getProperties();
            CEventTableContent event = new CEventTableContent();
            for (String key : properties.getKeys()) {
                CEventTableCell cell1 = new CEventTableCell(COLUMN_KEY, key);
                cell1.getLabelAttributes().setValue((Object)key);
                event.addCell(cell1);
                CEventTableCell cell2 = new CEventTableCell(COLUMN_VALUE, key);
                String value = properties.get(key);
                cell2.getLabelAttributes().setValue((Object)value);
                event.addCell(cell2);
            }
            this.mApi.setTableData(this.m600TableProperties, event);
            this.mServerContext.sendUpdate();
        }
    }

    void updatePresetList(Collection<String> aPresetNames) {
        LOG.info("Send PresetList List Data");
        CEventListContent event = new CEventListContent();
        for (String presetName : aPresetNames) {
            CEventLabelItem item = new CEventLabelItem(presetName);
            item.getAttributes().setValue((Object)presetName);
            event.add(item);
        }
        this.mApi.setListContent(this.m600ListPresets, event);
    }

    void update(UUID aApplicationId, String aName, String aShortDesc, String aLongDesc) {
        this.mApi.setText(this.m605TfAppId, CUtilUuid.toString((UUID)aApplicationId));
        this.mApi.setText(this.m605TfAppName, aName);
        this.mApi.setText(this.m605TfAppShortDescription, aShortDesc);
        this.mApi.setText(this.m605TfAppLongDescription, aLongDesc);
        this.mServerContext.sendUpdate();
    }

    void selectPreset(@NotNull String aName) {
        String old = this.mModel.getNameOfSelectedPreset();
        boolean hasOld = CUtilString.isValid((String)old);
        this.mModel.setSelectedPreset(aName);
        String newName = this.mModel.getNameOfSelectedPreset();
        boolean hasNew = CUtilString.isValid((String)newName);
        if (hasNew != hasOld) {
            this.mApi.setEnabled(this.m600ButtonCopyPreset, hasNew);
            this.mApi.setEnabled(this.m600ButtonDeletePreset, hasNew);
            this.mApi.setEnabled(this.m600ButtonRenamePreset, hasNew);
            this.mApi.setEnabled(this.m600ButtonRun, hasNew);
            this.mServerContext.sendUpdate();
        }
    }

    void askDeleteProperty(@NotNull String aKey) {
        CMessageBox msgBox = this.mServerContext.createMessageBox(this.mWs600, "#600MessageBox");
        msgBox.setTitle("Delete Property");
        msgBox.setText("Do you want to delete the Property '" + aKey + "'?");
        msgBox.setButtons(new String[]{"Okay", "Cancel"});
        msgBox.setMessageType(EMessageBoxType.question);
        this.mApi.setParent(msgBox.getWidgetId(), this.m600TableProperties);
        msgBox.setIndexOfEnterButton(0);
        msgBox.setIndexOfEscapeButton(1);
        msgBox.addListener((IListener)((IDialogButtonListener)this::onMessageBoxDeletePropertyResult));
        msgBox.showDialog();
        this.mServerContext.sendUpdate();
    }

    private void onMessageBoxDeletePropertyResult(@NotNull String aAnswer) {
        if ("Okay".equals(aAnswer)) {
            this.mModel.getPresetTarget().onAnswerDeleteProperty();
        }
    }

    void renamePreset(@NotNull String aPresetName) throws CException {
        CServiceRegistry sr = CServiceRegistry.getInstance();
        IStringInputFactory fac = (IStringInputFactory)sr.getServiceOrThrow(IStringInputFactory.class);
        IStringInputDialog dlg = fac.create(this.mModel.getServerContext(), this.mModel.getTargetRegistry());
        dlg.setTitle("Rename Preset");
        dlg.setMessage("<HTML>Enter <B>Preset</B> Name</HTML>");
        dlg.setParent(this.m600ListPresets);
        dlg.setInitialInputValue(aPresetName);
        dlg.setBackgroundColor(CNamedColors.get((String)"green").getColor(255));
        dlg.setForegroundColor(CNamedColors.get((String)"white").getColor(255));
        dlg.addListener(this::onRenamePreset);
        dlg.showDialog();
    }

    private void onRenamePreset(@NotNull CEventStringInputDialogResult aEvent) throws CException {
        if ("Okay".equals(aEvent.getButton())) {
            this.mModel.getPresetTarget().onRenamePreset(aEvent.getOldValue(), aEvent.getNewValue());
        }
    }

    void askDeletePreset(@Nullable String aPresetName) {
        if (CUtilString.isValid((String)aPresetName)) {
            CMessageBox msgBox = this.mServerContext.createMessageBox(this.mWs600, "#600MessageBox");
            msgBox.setTitle("Delete Preset");
            msgBox.setText("Do you want to delete the Preset '" + aPresetName + "'?");
            msgBox.setButtons(new String[]{"Okay", "Cancel"});
            msgBox.setMessageType(EMessageBoxType.question);
            this.mApi.setParent(msgBox.getWidgetId(), this.m600TableProperties);
            msgBox.setIndexOfEnterButton(0);
            msgBox.setIndexOfEscapeButton(1);
            msgBox.addListener((IListener)((IDialogButtonListener)this::onMessageBoxDeletePresetResult));
            msgBox.showDialog();
            this.mServerContext.sendUpdate();
        }
    }

    private void onMessageBoxDeletePresetResult(@NotNull String aAnswer) {
        if ("Okay".equals(aAnswer)) {
            this.mModel.getPresetTarget().onAnswerDeletePreset();
        }
    }

    void enterPresetNameOnPaste() throws CException {
        CServiceRegistry sr = CServiceRegistry.getInstance();
        IStringInputFactory fac = (IStringInputFactory)sr.getServiceOrThrow(IStringInputFactory.class);
        IStringInputDialog dlg = fac.create(this.mModel.getServerContext(), this.mModel.getTargetRegistry());
        dlg.setTitle("Paste Preset");
        dlg.setMessage("<HTML>Enter a new <strong>Preset</strong> Name</HTML>");
        dlg.setParent(this.m600ListPresets);
        dlg.setBackgroundColor(CNamedColors.get((String)"green").getColor(255));
        dlg.setForegroundColor(CNamedColors.get((String)"white").getColor(255));
        dlg.addListener(this::onEnterNewPresetName);
        dlg.showDialog();
    }

    private void onEnterNewPresetName(@NotNull CEventStringInputDialogResult aAnswer) {
        if ("Okay".equals(aAnswer.getButton())) {
            this.mModel.getPresetTarget().onEnterNewPresetName(aAnswer.getNewValue());
        }
    }

    void mountWidgetSet600() {
        this.mServerContext.mountWidgetSet(this.mWs600, this.mModel.getDialogDto().getParentWidgetId(), "#600_Panel_Main", this::widgetSet600Mounted);
        this.mServerContext.sendUpdate();
    }
}

