/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.web.protocol;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddClassesToElement;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddScript;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddStyleSheet;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddTableRowListener;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAlert;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebDeregisterWidgetOwner;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebListenOnClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebListenOnClick2;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebLoadImage;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebOpenNewTab;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRegisterWidgetOwner;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveClassesFromElement;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveElement;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveScript;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveStyleSheet;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSetInnerHtml;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSetStylesForElements;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSetValue;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebShowModal;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebUikitAlert;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWebApi {
    private final ITarget mTarget;
    private final CTargetAddress mRemoteSkinAddress;

    public CWebApi(@NotNull ITarget aTarget, @NotNull CTargetAddress aRemoteSkinAddress) {
        this.mTarget = aTarget;
        this.mRemoteSkinAddress = aRemoteSkinAddress;
    }

    public void registerWidgets(String @NotNull [] aWidgetIds) throws CException {
        if (aWidgetIds.length > 0) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
            CRecord record = CRecordWebRegisterWidgetOwner.create();
            CRecordWebRegisterWidgetOwner.setWidgetIds(record, aWidgetIds);
            this.mTarget.sendNotification(env, record);
        }
    }

    public void deregisterWidgetOwner() throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebDeregisterWidgetOwner.create();
        this.mTarget.sendNotification(env, record);
    }

    public void addTableRowListener(@NotNull String aWidgetId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAddTableRowListener.create();
        CRecordWebAddTableRowListener.setId(record, aWidgetId);
        this.mTarget.sendNotification(env, record);
    }

    public void setInnerHtml(@NotNull String aWidgetId, @NotNull String aText) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebSetInnerHtml.create();
        CRecordWebSetInnerHtml.setId(record, aWidgetId);
        CRecordWebSetInnerHtml.setHtml(record, aText);
        this.mTarget.sendNotification(env, record);
    }

    public void addClickListener1(@NotNull String aId, @NotNull String[] aWidgetIds) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebListenOnClick1.create();
        CRecordWebListenOnClick1.setId(record, aId);
        CRecordWebListenOnClick1.setWidgetIds(record, aWidgetIds);
        this.mTarget.sendNotification(env, record);
    }

    public void addClickListener2(@NotNull String[] aIds) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebListenOnClick2.create();
        CRecordWebListenOnClick2.setIds(record, aIds);
        this.mTarget.sendNotification(env, record);
    }

    public void openNewTab(boolean aSameUrl, @Nullable String aUrl, @Nullable CStringProperties aProperties) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebOpenNewTab.create();
        CRecordWebOpenNewTab.setSameUrl(record, aSameUrl);
        if (CUtilString.isValid((String)aUrl)) {
            CRecordWebOpenNewTab.setUrl(record, aUrl);
        }
        if (aProperties != null && !aProperties.isEmpty()) {
            CRecordWebOpenNewTab.setParameter(record, aProperties);
        }
        this.mTarget.sendNotification(env, record);
    }

    public void addClassToElement(@NotNull String aSelector, @NotNull String aClass) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAddClassesToElement.create();
        CRecordWebAddClassesToElement.setSelector(record, aSelector);
        CRecordWebAddClassesToElement.setClass(record, aClass);
        this.mTarget.sendNotification(env, record);
    }

    public void addClassesToElement(@NotNull String aSelector, @NotNull Collection<String> aClasses) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAddClassesToElement.create();
        CRecordWebAddClassesToElement.setSelector(record, aSelector);
        CRecordWebAddClassesToElement.setClasses(record, aClasses.toArray(new String[0]));
        this.mTarget.sendNotification(env, record);
    }

    public void removeClassFromElement(@NotNull String aSelector, @NotNull String aClass) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebRemoveClassesFromElement.create();
        CRecordWebRemoveClassesFromElement.setSelector(record, aSelector);
        CRecordWebRemoveClassesFromElement.setClass(record, aClass);
        this.mTarget.sendNotification(env, record);
    }

    public void removeClassesFromElement(@NotNull String aSelector, @NotNull Collection<String> aClasses) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebRemoveClassesFromElement.create();
        CRecordWebRemoveClassesFromElement.setSelector(record, aSelector);
        CRecordWebRemoveClassesFromElement.setClasses(record, aClasses.toArray(new String[0]));
        this.mTarget.sendNotification(env, record);
    }

    public void showModal(@NotNull String aId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebShowModal.create();
        CRecordWebShowModal.setId(record, aId);
        this.mTarget.sendNotification(env, record);
    }

    public void addCss(@NotNull String aStyleSheetId, @NotNull String aCss) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAddStyleSheet.create();
        CRecordWebAddStyleSheet.setId(record, aStyleSheetId);
        CRecordWebAddStyleSheet.setContent(record, aCss);
        this.mTarget.sendNotification(env, record);
    }

    public void removeCss(@NotNull String aId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebRemoveStyleSheet.create();
        CRecordWebRemoveStyleSheet.setId(record, aId);
        this.mTarget.sendNotification(env, record);
    }

    public void setValue(@NotNull String aId, @NotNull String aValue) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebSetValue.create();
        CRecordWebSetValue.setId(record, aId);
        CRecordWebSetValue.setValue(record, aValue);
        this.mTarget.sendNotification(env, record);
    }

    public void removeElement(@NotNull String aId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebRemoveElement.create();
        CRecordWebSetValue.setId(record, aId);
        this.mTarget.sendNotification(env, record);
    }

    public void alert(@NotNull String aMessage) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAlert.create();
        CRecordWebAlert.setMessage(record, aMessage);
        this.mTarget.sendNotification(env, record);
    }

    public void uikitAlert(@NotNull String aMessage, @Nullable CStringProperties aOptions) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAlert.create();
        CRecordWebUikitAlert.setMessage(record, aMessage);
        CRecordWebUikitAlert.setOptions(record, aOptions);
        this.mTarget.sendNotification(env, record);
    }

    public void setStylesForElements(@NotNull String aSelector, @NotNull CStringProperties aStyles) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebSetStylesForElements.create();
        CRecordWebSetStylesForElements.setSelector(record, aSelector);
        CRecordWebSetStylesForElements.setStyles(record, aStyles);
        this.mTarget.sendNotification(env, record);
    }

    public void loadImage(@NotNull String aRelativePath, @NotNull String aElementId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebLoadImage.create();
        CRecordWebLoadImage.setRelativePath(record, aRelativePath);
        CRecordWebLoadImage.setElementId(record, aElementId);
        this.mTarget.sendNotification(env, record);
    }

    public void addScript(@NotNull String aId, @Nullable String aContent, @Nullable String aSource) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebAddScript.create();
        CRecordWebAddScript.setId(record, aId);
        if (aContent != null) {
            CRecordWebAddScript.setContent(record, aContent);
        }
        if (aSource != null) {
            CRecordWebAddScript.setSrc(record, aSource);
        }
        this.mTarget.sendNotification(env, record);
    }

    public void removeScript(@NotNull String aId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteSkinAddress);
        CRecord record = CRecordWebRemoveScript.create();
        CRecordWebRemoveScript.setId(record, aId);
        this.mTarget.sendNotification(env, record);
    }
}

