/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.client;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.tcp.client.CTargetForTcpClient;
import de.sillysky.nyssr.impl.tcp.client.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.tcp.ITcpClient;
import de.sillysky.nyssr.tcp.ITcpConnection;
import de.sillysky.nyssr.tcp.ITcpConnectionOwner;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.UUID;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTcpClient
implements ITcpClient,
ITcpConnectionOwner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpClient.class);
    private static final int TIMEOUT = 10000;
    private UUID mId = UUID.randomUUID();
    private boolean mTlsEnabled;
    private String mTlsProtocols;
    private String mTlsCipherSuites;
    private int mPort;
    private String mHost;
    private int mInputBufferSize;
    private long mRetryTimeout;
    private boolean mFailOnFirstConnect;
    private int mConnectCount = 0;
    private boolean mWantRetryMessage = false;
    private ITcpConnection mConnection;
    private CTargetForTcpClient mTarget;
    private IDependencies mDependencies;
    private CTargetAddress mOwner;

    CTcpClient() {
    }

    void activateInstance(@NotNull IDependencies aDependencies, @NotNull CTargetAddress aOwner, @NotNull CStringProperties aProperties) throws Exception {
        this.mDependencies = aDependencies;
        this.mOwner = aOwner;
        LOG.debug("Activate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.setProperties(aProperties);
        this.mTarget = new CTargetForTcpClient();
        this.mTarget.activate(this.mDependencies, this, this.mRetryTimeout);
        this.connect();
    }

    @Override
    public void connect() throws Exception {
        LOG.info("Start TcpClient on {} Port {}", new Object[]{this.mHost, this.mPort});
        try {
            Socket socket;
            InetSocketAddress sockAddr = new InetSocketAddress(this.mHost, this.mPort);
            if (this.mTlsEnabled) {
                SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket ss = (SSLSocket)sslsocketfactory.createSocket(this.mHost, this.mPort);
                @NotNull String[] protocols = CUtilStringArray.fromString((String)this.mTlsProtocols, (char)',');
                ss.setEnabledProtocols(protocols);
                @NotNull String[] cipherSuites = CUtilStringArray.fromString((String)this.mTlsCipherSuites, (char)',');
                ss.setEnabledCipherSuites(cipherSuites);
                socket = ss;
            } else {
                socket = new Socket();
                socket.setReuseAddress(true);
                socket.connect(sockAddr, 10000);
            }
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            this.mConnectCount = 0;
            this.mConnection = this.mDependencies.getTcpConnectionFactory().createConnection(this, socket, this.mInputBufferSize, false);
            LOG.debug("TCP Client started on {} Port {}", new Object[]{this.mHost, this.mPort});
        }
        catch (Exception e) {
            if (this.mFailOnFirstConnect && this.mConnectCount == 0) {
                LOG.error("Unable to connect {}:{}, (failOnFirstConnect=true, -> fail)", new Object[]{this.mHost, this.mPort});
                throw e;
            }
            ++this.mConnectCount;
            if (this.mRetryTimeout > 0L) {
                LOG.debug("Unable to connect {}:{}, set retry timer to {}", new Object[]{this.mHost, this.mPort, this.mRetryTimeout});
                this.mTarget.setRetryTimer(this.mRetryTimeout);
                if (this.mWantRetryMessage && this.mOwner != null) {
                    this.mTarget.sendRetryMessage();
                }
            }
            LOG.error("Unable to connect {}:{} (no retryTimeout -> fail)", new Object[]{this.mHost, this.mPort});
            throw e;
        }
    }

    void deactivateInstance() {
        LOG.debug("Deactivate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.disconnect();
        if (this.mRetryTimeout <= 0L) {
            this.mTarget.deactivate();
            this.mTarget = null;
        }
    }

    @Override
    public void deleteMe(ITcpConnection aConnection) {
        this.deactivateInstance();
    }

    @Override
    public synchronized void disconnect() {
        if (this.mConnection != null) {
            this.mConnection.close();
            this.mDependencies.getTcpConnectionFactory().deleteConnection(this.mConnection);
            this.mConnection = null;
        }
    }

    @Override
    public ITcpConnection getConnection() {
        return this.mConnection;
    }

    @Override
    public UUID getConnectionID() {
        return this.mId;
    }

    @Override
    public String getHost() {
        return this.mHost;
    }

    @Override
    public UUID getID() {
        return this.mId;
    }

    @Override
    public int getInputBufferSize() {
        return this.mInputBufferSize;
    }

    @Override
    public int getLocalPort() {
        if (this.mConnection != null) {
            return this.mConnection.getLocalPort();
        }
        return 0;
    }

    @Override
    public int getPort() {
        return this.mPort;
    }

    @Override
    public long getRetryTimeout() {
        return this.mRetryTimeout;
    }

    @Override
    @Nullable
    public CTargetAddress getOwner() {
        return this.mOwner;
    }

    @Override
    public int getRetryCounter() {
        return this.mConnectCount;
    }

    @Override
    public boolean isConnected() {
        if (this.mConnection != null) {
            this.mConnection.isConnected();
        }
        return false;
    }

    @Override
    public boolean isTlsEnabled() {
        return this.mTlsEnabled;
    }

    @Override
    @NotNull
    public String getTlsProtocols() {
        return this.mTlsProtocols;
    }

    @Override
    @NotNull
    public String getTlsCipherSuites() {
        return this.mTlsCipherSuites;
    }

    @Override
    public boolean match(String aHost, int aPort) {
        if (this.mPort == aPort) {
            return CUtilString.equals((String)aHost, (String)this.mHost);
        }
        return false;
    }

    @Override
    public void reconnect() throws Exception {
        this.connect();
    }

    private void setProperties(@NotNull CStringProperties aProperties) throws Exception {
        String value = aProperties.get("id");
        if (CUtilString.isEmpty((String)value)) {
            throw new CException(7).append("ID missing");
        }
        this.mId = CUtilUuid.fromString((String)value);
        if (CUtilUuid.isEmpty((UUID)this.mId)) {
            throw new CException(7).append("ID missing");
        }
        LOG.debug("ID = {}", new Object[]{this.mId});
        value = aProperties.get("tls.enabled", Boolean.FALSE.toString());
        this.mTlsEnabled = Boolean.parseBoolean(value);
        LOG.debug("enable.tls = {}", new Object[]{this.mTlsEnabled});
        this.mTlsProtocols = aProperties.get("tls.protocols", "");
        if (!this.mTlsProtocols.isEmpty()) {
            LOG.debug("protocols = {}", new Object[]{this.mTlsProtocols});
        }
        this.mTlsCipherSuites = aProperties.get("tls.cipher.suites", "");
        if (!this.mTlsCipherSuites.isEmpty()) {
            LOG.debug("cipher suites = {}", new Object[]{this.mTlsCipherSuites});
        }
        if (CUtilString.isEmpty((String)(value = aProperties.get("port")))) {
            throw new CException(7).append("Port missing");
        }
        this.mPort = Integer.parseInt(value);
        LOG.debug("port = {}", new Object[]{this.mPort});
        value = aProperties.get("host");
        if (CUtilString.isEmpty((String)value)) {
            throw new CException(7).append("Host missing");
        }
        this.mHost = value;
        LOG.debug("host = {}", new Object[]{this.mHost});
        value = aProperties.get("input.buffer.size", Integer.toString(270000));
        this.mInputBufferSize = Integer.parseInt(value);
        LOG.debug("inputbuffersize = {}", new Object[]{this.mInputBufferSize});
        value = aProperties.get("retry.timeout");
        if (CUtilString.isValid((String)value)) {
            this.mRetryTimeout = Integer.parseInt(value);
        }
        LOG.debug("retryTimeout = {}", new Object[]{this.mRetryTimeout});
        value = aProperties.get("fail.on.first.connect");
        this.mFailOnFirstConnect = CUtilString.isValid((String)value) ? Boolean.parseBoolean(value) : false;
        LOG.debug("failOnFirstConnect = {}", new Object[]{this.mFailOnFirstConnect});
        value = aProperties.get("want.retry.msg");
        this.mWantRetryMessage = CUtilString.isValid((String)value) ? Boolean.parseBoolean(value) : false;
        LOG.debug("WantRetryMessage = {}", new Object[]{value});
    }

    @Override
    public synchronized void dispose() {
        this.disconnect();
        if (this.mTarget != null) {
            if (this.mOwner != null) {
                this.mTarget.sendNotifyClientDeleted(this.mOwner);
            }
            this.mTarget.deactivate();
            this.mTarget = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + CUtilUuid.toShortString((UUID)this.getID()) + " for " + this.mHost + ":" + this.mPort;
    }
}

