/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.client;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.tcp.client.CTcpClient;
import de.sillysky.nyssr.impl.tcp.client.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.tcp.ITcpClient;
import de.sillysky.nyssr.tcp.ITcpClientFactory;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTcpClientFactory
implements ITcpClientFactory,
IService {
    static final String FILTER = "nid=TCP";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpClientFactory.class);
    private final IDependencies mDependencies;

    CTcpClientFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(ITcpClientFactory.class, (Object)this);
    }

    @Override
    @NotNull
    public ITcpClient createClient(@Nullable CTargetAddress aOwner, @NotNull CStringProperties aProperties) throws CException {
        CTcpClient client = new CTcpClient();
        try {
            client.activateInstance(this.mDependencies, aOwner, aProperties);
        }
        catch (Exception e) {
            try {
                client.deactivateInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CException(2).append((Object)e);
        }
        return client;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deleteClient(@NotNull ITcpClient aClient) {
        try {
            aClient.disconnect();
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error disconnecting the TCP client {}", new Object[]{aClient.toString()});
        }
    }
}

