/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.impl.session.manager.ILocalService;
import de.sillysky.nyssr.util.CUtilUuid;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class CSessionEntry {
    private final String mToken;
    private final String mUserId;
    private final Collection<String> mRights;
    private final ILocalService mLocalService;
    private ZonedDateTime mTimeStamp;

    CSessionEntry(@NotNull ILocalService aLocalService, @NotNull String aUserId, @NotNull Collection<String> aRights) {
        this.mLocalService = aLocalService;
        this.mToken = CUtilUuid.random().toString();
        this.mUserId = aUserId;
        this.mRights = aRights;
        this.mTimeStamp = ZonedDateTime.now();
    }

    String getToken() {
        return this.mToken;
    }

    String getUserId() {
        return this.mUserId;
    }

    boolean hasRight(@NotNull String aRight) {
        for (String role : this.mRights) {
            if (!role.equals(aRight)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mUserId;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSessionEntry that = (CSessionEntry)aO;
        return this.mToken.equals(that.mToken);
    }

    public int hashCode() {
        return Objects.hash(this.mToken);
    }

    ZonedDateTime getTimeStamp() {
        return this.mTimeStamp;
    }

    void notifyActivity() {
        this.mTimeStamp = ZonedDateTime.now();
    }

    boolean isExpired() {
        return this.mTimeStamp.isBefore(ZonedDateTime.now().minusMinutes(this.mLocalService.getTimeoutInMinutes()));
    }
}

