/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.session.manager.CSessionEntry;
import de.sillysky.nyssr.impl.session.manager.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionExpired;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CSessionList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSessionList.class);
    private final Map<String, CSessionEntry> mSessions = new ConcurrentHashMap<String, CSessionEntry>();
    private final IDependencies mDependencies;

    CSessionList(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    void add(@NotNull CSessionEntry aSession) {
        this.mSessions.put(aSession.getToken(), aSession);
    }

    CSessionEntry remove(@NotNull String aToken) {
        return this.mSessions.remove(aToken);
    }

    CSessionEntry get(@Nullable String aToken) {
        return aToken == null ? null : this.mSessions.get(aToken);
    }

    public String toString() {
        return "[SessionList: " + this.mSessions.size() + " entries]";
    }

    void doMaintenance(@NotNull ITarget aTarget) {
        this.mSessions.values().removeIf(session -> this.isSessionExpired((CSessionEntry)session, aTarget));
    }

    private boolean isSessionExpired(@NotNull CSessionEntry aSession, @NotNull ITarget aTarget) {
        boolean expired = aSession.isExpired();
        if (expired) {
            LOG.debug("Session expired: {}", new Object[]{aSession.getToken()});
            this.sendSessionExpiredNotification(aSession, aTarget.getAddress());
        }
        return expired;
    }

    private void sendSessionExpiredNotification(@NotNull CSessionEntry aSession, @NotNull CTargetAddress aSender) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordSessionExpired.class);
            env.setSender(aSender);
            CRecord record = CRecordSessionExpired.create();
            CRecordSessionExpired.setSessionToken((CRecord)record, (String)aSession.getToken());
            this.mDependencies.getBroadcastService().broadcastMessage(env, record, true);
        }
        catch (CException aException) {
            LOG.error((Throwable)aException);
        }
    }
}

