/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.link.cost.collector;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.impl.network.link.cost.collector.CCostEntry;
import de.sillysky.nyssr.impl.network.link.cost.collector.CLinkKey;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CCostList {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.costs");
    private final Map<CLinkKey, CCostEntry> mCosts = new HashMap<CLinkKey, CCostEntry>();

    CCostList() {
    }

    void addCosts(@NotNull CNodeId aNode1, @NotNull CNodeId aNode2, int aCosts, boolean aFix) {
        String action;
        CLinkKey key = new CLinkKey(aNode1, aNode2);
        CCostEntry entry = this.mCosts.get(key);
        if (entry == null) {
            entry = new CCostEntry(key, aCosts, aFix);
            this.mCosts.put(key, entry);
            action = "Add";
        } else {
            if (!entry.isFix()) {
                entry.setCosts(aCosts);
            }
            action = "Update";
        }
        LOG.debug("{} fixed costs: {} -- {} -- {}", new Object[]{action, key.getNode1(), aCosts, key.getNode2()});
    }

    int getCosts(@NotNull CNodeId aNode1, @NotNull CNodeId aNode2) {
        CLinkKey key = new CLinkKey(aNode1, aNode2);
        return this.getCosts(key);
    }

    int getCosts(@NotNull CLinkKey aKey) {
        CCostEntry entry = this.mCosts.get(aKey);
        return entry == null ? 1 : entry.getCosts();
    }

    Collection<CCostEntry> costs() {
        return this.mCosts.values();
    }

    void removeOldEntries(int aTimeoutInSeconds) {
        this.mCosts.values().removeIf(e -> e.canBeRemoved(aTimeoutInSeconds));
    }
}

