/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CButtonAndRight;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.model.util.EMessageBoxType;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IDialogButtonListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.remoteskin.server.widgets.CMessageBox;
import de.sillysky.nyssr.util.CUtilCollection;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class C706Handler {
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs706;
    private final CWidgetId m706Dialog;
    private final CWidgetId m706ListRoles;
    private final CWidgetId m706ListRights;
    private final CWidgetId m706ButtonOkay;
    private final CWidgetId m706ButtonCreateRole;
    private final CWidgetId m706ButtonDeleteRole;
    private final CWidgetId m706ButtonEditRole;
    private final CWidgetId m706LabelMessage;
    private final CWidgetId m706ButtonGrantRight;
    private final CWidgetId m706ButtonRevokeRight;
    private final ArrayList<String> mSelectedRights = new ArrayList();
    private final CButtonAndRight mButtonAndRight;
    private String mSelectedRole = "";
    private boolean mRoleButtonsAreEnabled;
    private boolean mRightButtonsAreEnabled;
    private boolean m706open;
    private CWidgetId mParentWidget;
    private Collection<String> mRoles;

    C706Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance, @NotNull CButtonAndRight aButtonAndRight) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mButtonAndRight = aButtonAndRight;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs706 = CWidgetSetId.create((String)"@706_EditRoles", (String)aInstance);
        this.m706Dialog = CWidgetId.create((String)"#706_Dialog", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m706ListRoles = CWidgetId.create((String)"#706_ListRoles", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ListRoles, (IListener)((IListSelectionListener)this::onListRoleSelection));
        this.m706ListRights = CWidgetId.create((String)"#706_ListRights", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ListRights, (IListener)((IListSelectionListener)this::onListRightSelection));
        this.m706ButtonOkay = CWidgetId.create((String)"#706_ButtonOkay", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        this.m706ButtonCreateRole = CWidgetId.create((String)"#706_ButtonCreateRole", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ButtonCreateRole, (IListener)((IButtonPressedListener)this::onButtonCreateRole));
        this.m706ButtonDeleteRole = CWidgetId.create((String)"#706_ButtonDeleteRole", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ButtonDeleteRole, (IListener)((IButtonPressedListener)this::onButtonDeleteRole));
        this.m706ButtonEditRole = CWidgetId.create((String)"#706_ButtonEditRoleData", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ButtonEditRole, (IListener)((IButtonPressedListener)this::onButtonEditRole));
        this.m706ButtonGrantRight = CWidgetId.create((String)"#706_ButtonGrantRight", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ButtonGrantRight, (IListener)((IButtonPressedListener)this::onButtonGrantRight));
        this.m706ButtonRevokeRight = CWidgetId.create((String)"#706_ButtonRevokeRight", (CWidgetSetId)this.mWs706);
        this.mApi.addListener(this.m706ButtonRevokeRight, (IListener)((IButtonPressedListener)this::onButtonRevokeRight));
        this.m706LabelMessage = CWidgetId.create((String)"#706_LabelMessage", (CWidgetSetId)this.mWs706);
    }

    private void onButtonGrantRight(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notifyButton706GrantRightPressed(this.m706ButtonGrantRight, this.mSelectedRole);
    }

    private void onButtonRevokeRight(@NotNull CEventButtonPressedNotification aEvent) {
        CMessageBox msgBox = this.mServerContext.createMessageBox(this.mWs706, "#706MBRevokeRight");
        msgBox.setTitle("Revoke rights");
        msgBox.setText("Do you really want to revoke this rights: " + CUtilCollection.toString(this.mSelectedRights));
        msgBox.setButtons(new String[]{"Okay", "Cancel"});
        msgBox.setMessageType(EMessageBoxType.question);
        this.mApi.setParent(msgBox.getWidgetId(), this.m706ButtonRevokeRight);
        msgBox.setIndexOfEnterButton(0);
        msgBox.setIndexOfEscapeButton(1);
        msgBox.addListener((IListener)((IDialogButtonListener)aButtonChosen -> {
            if ("Okay".equals(aButtonChosen)) {
                this.mMainTarget.sendRevokeRights(this.mSelectedRole, this.mSelectedRights);
            }
        }));
        msgBox.showDialog();
        this.mServerContext.sendUpdate();
    }

    private void onButtonDeleteRole(@NotNull CEventButtonPressedNotification aEvent) {
        CMessageBox msgBox = this.mServerContext.createMessageBox(this.mWs706, "#706MBDeleteRole");
        msgBox.setTitle("Delete a Role");
        msgBox.setText("Do you really want to delete this role: " + this.mSelectedRole);
        msgBox.setButtons(new String[]{"Okay", "Cancel"});
        msgBox.setMessageType(EMessageBoxType.question);
        this.mApi.setParent(msgBox.getWidgetId(), this.m706ButtonDeleteRole);
        msgBox.setIndexOfEnterButton(0);
        msgBox.setIndexOfEscapeButton(1);
        msgBox.addListener((IListener)((IDialogButtonListener)aButtonChosen -> {
            if ("Okay".equals(aButtonChosen)) {
                this.mMainTarget.sendDeleteRole(this.mSelectedRole);
            }
        }));
        msgBox.showDialog();
        this.mServerContext.sendUpdate();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget, @NotNull Collection<String> aRoles) {
        if (!this.m706open) {
            this.m706open = true;
            this.mRoles = aRoles;
            this.mParentWidget = aParentWidget;
            this.mRoleButtonsAreEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs706, this.mParentWidget, "#706_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    private void fillRoles(@NotNull Collection<String> aRoles) {
        CEventListContent event = new CEventListContent();
        for (String role : aRoles) {
            CEventLabelItem item = new CEventLabelItem(role);
            item.getAttributes().setValue((Object)role);
            event.add(item);
        }
        this.mApi.setListContent(this.m706ListRoles, event);
    }

    private void fillRights(@NotNull @NotNull String @NotNull [] aRights) {
        if (this.m706open) {
            CEventListContent event = new CEventListContent();
            for (String right : aRights) {
                CEventLabelItem item = new CEventLabelItem(right);
                item.getAttributes().setValue((Object)right);
                event.add(item);
            }
            this.mApi.setListContent(this.m706ListRights, event);
        }
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs706.equals((Object)aWidgetSetId)) {
            this.mButtonAndRight.addAll(this.m706ButtonGrantRight, this.m706ButtonCreateRole, this.m706ButtonDeleteRole, this.m706ButtonRevokeRight, this.m706ButtonEditRole);
            this.mApi.pack(this.m706Dialog);
            this.mApi.centerWidget(this.m706Dialog, this.mParentWidget);
            this.fillRoles(this.mRoles);
            this.mApi.selectItem(this.m706ListRoles, "Administrator");
            this.mApi.setVisible(this.m706Dialog, true);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m706open) {
            this.m706open = false;
            this.mApi.unmount(this.m706Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onButtonCreateRole(@NotNull CEventButtonPressedNotification aEvent) {
        this.mMainTarget.notifyButton706CreateRolePressed();
    }

    private void onButtonEditRole(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notifyButton706EditRoleDataPressed(this.mSelectedRole);
    }

    private void onListRoleSelection(@NotNull CEventListSelectionNotification aEvent) throws CException {
        List selectedIds = aEvent.getSelectedIds();
        String s = (String)CUtilCollection.getFirst((Collection)selectedIds);
        String string = this.mSelectedRole = s == null ? "" : s;
        if (!this.mSelectedRole.isEmpty()) {
            this.mMainTarget.sendGetRightList(this.mSelectedRole);
        }
        this.mButtonAndRight.check(this.mSelectedRole, null, this.m706ButtonCreateRole, "NY_CreateRole");
        this.mButtonAndRight.check(this.mSelectedRole, null, this.m706ButtonDeleteRole, "NY_DeleteRole");
        this.mButtonAndRight.check(this.mSelectedRole, null, this.m706ButtonEditRole, "NY_ChangeRight");
        this.mButtonAndRight.check(this.mSelectedRole, null, this.m706ButtonGrantRight, "NY_GrantRight");
        this.sendUpdate();
    }

    private void onListRightSelection(@NotNull CEventListSelectionNotification aEvent) {
        this.mSelectedRights.clear();
        List selectedIds = aEvent.getSelectedIds();
        this.mSelectedRights.addAll(selectedIds);
        this.mButtonAndRight.check(CUtilCollection.getFirst((Collection)selectedIds), null, this.m706ButtonRevokeRight, "NY_RevokeRight");
        this.sendUpdate();
    }

    public void setRights(@NotNull String aRoleId, @NotNull String[] aRights) {
        if (aRoleId.equals(this.mSelectedRole)) {
            this.fillRights(aRights);
            this.sendUpdate();
        }
    }

    public void setRoles(List<String> aRoles, String aSelectedRole) {
        this.mRoles = aRoles;
        this.fillRoles(this.mRoles);
        if (CUtilString.isValid((String)aSelectedRole)) {
            this.mSelectedRole = aSelectedRole;
            this.mApi.selectItem(this.m706ListRoles, this.mSelectedRole);
        }
        this.sendUpdate();
    }

    public boolean isShown() {
        return this.m706open;
    }

    public String getRoleId() {
        return this.mSelectedRole;
    }
}

