/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.addrole;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.addrole.CConstants;
import de.sillysky.nyssr.impl.web.dialog.addrole.IDependencies;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbCreateRole;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00306AddRole
extends CTarget {
    private final IDependencies mDependencies;
    private final String mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00306_MODAL = "id_00306_modal";
    private static final String ID_00306_CANCEL = "id_00306_cancel";
    private static final String ID_00306_SAVE = "id_00306_save";
    private static final String ID_00306_ROLE_ID = "id_00306_role_id";
    private static final String ID_00306_DESCRIPTION = "id_00306_description";
    private static final String ID_00306_ROLE_ID_ALERT = "id_00306_role_id_alert";
    private static final String[] WIDGETS = new String[]{"id_00306_cancel", "id_00306_save"};
    private final CRole mRole = new CRole();

    public C00306AddRole(@NotNull IDependencies aDependencies, @NotNull String aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress) {
        this.mDependencies = aDependencies;
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbCreateRole.ID, this::asyncUserDbCreateRole);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.mWebApi.registerWidgets(WIDGETS);
        this.showDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        boolean errors = false;
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String alert;
            String roleId = values.get(ID_00306_ROLE_ID, "");
            if (CUtilString.isEmpty((String)roleId)) {
                alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00306_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"ID is empty.");
                this.mWebApi.setInnerHtml(ID_00306_ROLE_ID_ALERT, alert);
                errors = true;
            } else if (roleId.contains(" ")) {
                alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00306_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"ID contains spaces.");
                this.mWebApi.setInnerHtml(ID_00306_ROLE_ID_ALERT, alert);
                errors = true;
            } else {
                this.mRole.setId(roleId);
            }
            String description = values.get(ID_00306_DESCRIPTION, "");
            this.mRole.setDescription(description);
            if (!errors) {
                this.sendAddRole(this.mRole);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncUserDbCreateRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00306_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)aEnvelope.getResultText());
                this.mWebApi.setInnerHtml(ID_00306_ROLE_ID_ALERT, alert);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00306_add_role.html");
        this.mWebApi.removeElement(ID_00306_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.showModal(ID_00306_MODAL);
        this.mWebApi.addClickListener1(ID_00306_SAVE, new String[]{ID_00306_ROLE_ID, ID_00306_DESCRIPTION});
        this.mWebApi.addClickListener2(new String[]{ID_00306_CANCEL});
    }

    void sendAddRole(@NotNull CRole aRole) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        CRecord record = CRecordUserDbCreateRole.create();
        CRecord roleRecord = aRole.toRecord();
        CRecordUserDbCreateRole.setSessionToken((CRecord)record, (String)this.mSessionToken);
        CRecordUserDbCreateRole.setRoleRecord((CRecord)record, (CRecord)roleRecord);
        this.sendRequest(env, record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00306_MODAL);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, new String[]{this.mRole.getId()});
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

