/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventLineBorder
implements IBorder,
IRemoteSkinEvent {
    private final Color mColor;
    private final int mThickness;
    private final boolean mRoundedCorners;

    public CEventLineBorder(@NotNull Color aColor, int aThickness, boolean aRoundedCorners) {
        this.mColor = aColor;
        this.mThickness = aThickness;
        this.mRoundedCorners = aRoundedCorners;
    }

    @Nullable
    public static CEventLineBorder create(@Nullable Object aValue) {
        CJsonObject jo;
        Object o;
        CEventColor color;
        if (aValue instanceof CJsonObject && (color = CEventColor.create(o = (jo = (CJsonObject)aValue).getValue(EKeys.color.name()))) != null) {
            int thickness = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)EKeys.thickness.name(), (int)1);
            boolean rounded = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)EKeys.rounded.name(), (boolean)false);
            return new CEventLineBorder(color.createColor(), thickness, rounded);
        }
        return null;
    }

    public Color getColor() {
        return this.mColor;
    }

    public int getThickness() {
        return this.mThickness;
    }

    public boolean hasRoundedCorners() {
        return this.mRoundedCorners;
    }

    @Override
    public Border createBorder() {
        return new LineBorder(this.mColor, this.mThickness, this.mRoundedCorners);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        CEventColor color = new CEventColor(this.mColor);
        jo.put(EKeys.color.name(), color.toJson());
        jo.put(EKeys.thickness.name(), (Object)this.mThickness);
        jo.put(EKeys.rounded.name(), (Object)this.mRoundedCorners);
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.line;
    }

    public static enum EKeys {
        border_type,
        color,
        thickness,
        rounded;

    }
}

