/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.dialog.preset.CPreset;
import de.sillysky.nyssr.impl.dialog.preset.CPresetList;
import de.sillysky.nyssr.impl.dialog.preset.CPresetTarget;
import de.sillysky.nyssr.impl.dialog.preset.IDialogPresetDependencies;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPresetModel {
    private final IDialogPresetDependencies mDependencies;
    private final CPresetTarget mPresetTarget;
    private final CPresetList mPresetList = new CPresetList();
    private final CNodeAddress mNodeAddressOfAppStore;
    private final CTargetAddress mAddressForDisplayingMessages;
    private final CDialogDto mDialogDto;
    private String mSelectedPropertyKey = null;
    private String mProcessedPropertyKey = null;
    private CPreset mProcessedPreset = null;
    private boolean mWs600Loaded = false;
    private CPreset mClipBoardPreset = null;

    public CPresetModel(@NotNull IDialogPresetDependencies aDependencies, @NotNull CDialogDto aDialogDto, @NotNull CNodeAddress aNodeAddressOfAppStore, @Nullable CTargetAddress aAddressForDisplayingMessages, @NotNull CPresetTarget aPresetTarget) {
        this.mDependencies = aDependencies;
        this.mDialogDto = aDialogDto;
        this.mNodeAddressOfAppStore = aNodeAddressOfAppStore;
        this.mAddressForDisplayingMessages = aAddressForDisplayingMessages;
        this.mPresetTarget = aPresetTarget;
    }

    @NotNull
    public IDialogPresetDependencies getDependencies() {
        return this.mDependencies;
    }

    @NotNull
    public CPresetTarget getPresetTarget() {
        return this.mPresetTarget;
    }

    public String getSelectedPropertyKey() {
        return this.mSelectedPropertyKey;
    }

    public void setSelectedPropertyKey(String aSelectedPropertyKey) {
        this.mSelectedPropertyKey = aSelectedPropertyKey;
    }

    public String getProcessedPropertyKey() {
        return this.mProcessedPropertyKey;
    }

    public void setProcessedPropertyKey(String aProcessedPropertyKey) {
        this.mProcessedPropertyKey = aProcessedPropertyKey;
    }

    public CPreset getProcessedPreset() {
        return this.mProcessedPreset;
    }

    public void setProcessedPreset(@NotNull CPreset aProcessedPreset) {
        this.mProcessedPreset = aProcessedPreset;
    }

    @Nullable
    public CPreset getPreset(String aPresetName) {
        return this.mPresetList.get(aPresetName);
    }

    @Nullable
    public String getNameOfSelectedPreset() {
        return this.mPresetList.getNameOfSelectedPreset();
    }

    void setSelectedPreset(@NotNull String aName) {
        this.mPresetList.setSelected(aName);
    }

    CPresetList getPresetList() {
        return this.mPresetList;
    }

    public ITargetRegistry getTargetRegistry() {
        return this.mPresetTarget.getTargetRegistry();
    }

    public void setWs600Loaded() {
        this.mWs600Loaded = true;
    }

    public boolean isWs600Loaded() {
        return this.mWs600Loaded;
    }

    @NotNull
    public CNodeAddress getNodeAddressOfAppStore() {
        return this.mNodeAddressOfAppStore;
    }

    public IRemoteSkinServerContext getServerContext() {
        return this.mDialogDto.getServerContext();
    }

    @Nullable
    CPreset getClipBoardPreset() {
        return this.mClipBoardPreset;
    }

    void setClipBoardPreset(@Nullable CPreset aClipBoardPreset) {
        this.mClipBoardPreset = aClipBoardPreset;
    }

    @Nullable
    CTargetAddress getAddressForDisplayingMessages() {
        return this.mAddressForDisplayingMessages;
    }

    public CDialogDto getDialogDto() {
        return this.mDialogDto;
    }
}

